/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.TokenSearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleBreadthFirstSearchManager
extends TokenSearchManager {
    @S4Component(type=Linguist.class)
    public static final String PROP_LINGUIST = "linguist";
    @S4Component(type=Pruner.class)
    public static final String PROP_PRUNER = "pruner";
    @S4Component(type=AcousticScorer.class)
    public static final String PROP_SCORER = "scorer";
    @S4Component(type=ActiveListFactory.class)
    public static final String PROP_ACTIVE_LIST_FACTORY = "activeListFactory";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_TOKEN_COUNT = "showTokenCount";
    @S4Double(defaultValue=0.0)
    public static final String PROP_RELATIVE_WORD_BEAM_WIDTH = "relativeWordBeamWidth";
    @S4Boolean(defaultValue=false)
    public static final String PROP_WANT_ENTRY_PRUNING = "wantEntryPruning";
    @S4Integer(defaultValue=0)
    public static final String PROP_GROW_SKIP_INTERVAL = "growSkipInterval";
    protected Linguist linguist;
    private Pruner pruner;
    private AcousticScorer scorer;
    protected int currentFrameNumber;
    protected long currentCollectTime;
    protected ActiveList activeList;
    protected List<Token> resultList;
    protected LogMath logMath;
    private Logger logger;
    private String name;
    private Timer scoreTimer;
    private Timer pruneTimer;
    protected Timer growTimer;
    private StatisticsVariable totalTokensScored;
    private StatisticsVariable tokensPerSecond;
    private StatisticsVariable curTokensScored;
    private StatisticsVariable tokensCreated;
    private StatisticsVariable viterbiPruned;
    private StatisticsVariable beamPruned;
    protected boolean showTokenCount;
    private boolean wantEntryPruning;
    protected Map<SearchState, Token> bestTokenMap;
    private float logRelativeWordBeamWidth;
    private int totalHmms;
    private double startTime;
    private float threshold;
    private float wordThreshold;
    private int growSkipInterval;
    protected ActiveListFactory activeListFactory;
    protected boolean streamEnd;

    public SimpleBreadthFirstSearchManager() {
    }

    public SimpleBreadthFirstSearchManager(Linguist linguist, Pruner pruner, AcousticScorer acousticScorer, ActiveListFactory activeListFactory, boolean bl, double d, int n, boolean bl2) {
        this.name = this.getClass().getName();
        this.logger = Logger.getLogger(this.name);
        this.logMath = LogMath.getLogMath();
        this.linguist = linguist;
        this.pruner = pruner;
        this.scorer = acousticScorer;
        this.activeListFactory = activeListFactory;
        this.showTokenCount = bl;
        this.growSkipInterval = n;
        this.wantEntryPruning = bl2;
        this.logRelativeWordBeamWidth = this.logMath.linearToLog(d);
        this.keepAllTokens = true;
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.logMath = LogMath.getLogMath();
        this.logger = propertySheet.getLogger();
        this.name = propertySheet.getInstanceName();
        this.linguist = (Linguist)propertySheet.getComponent(PROP_LINGUIST);
        this.pruner = (Pruner)propertySheet.getComponent(PROP_PRUNER);
        this.scorer = (AcousticScorer)propertySheet.getComponent(PROP_SCORER);
        this.activeListFactory = (ActiveListFactory)propertySheet.getComponent(PROP_ACTIVE_LIST_FACTORY);
        this.showTokenCount = propertySheet.getBoolean(PROP_SHOW_TOKEN_COUNT);
        double d = propertySheet.getDouble(PROP_RELATIVE_WORD_BEAM_WIDTH);
        this.growSkipInterval = propertySheet.getInt(PROP_GROW_SKIP_INTERVAL);
        this.wantEntryPruning = propertySheet.getBoolean(PROP_WANT_ENTRY_PRUNING);
        this.logRelativeWordBeamWidth = this.logMath.linearToLog(d);
        this.keepAllTokens = true;
    }

    @Override
    public void startRecognition() {
        this.logger.finer("starting recognition");
        this.linguist.startRecognition();
        this.pruner.startRecognition();
        this.scorer.startRecognition();
        this.localStart();
        if (this.startTime == 0.0) {
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public Result recognize(int n) {
        boolean bl = false;
        Result result = null;
        this.streamEnd = false;
        for (int i = 0; i < n && !bl; ++i) {
            bl = this.recognize();
        }
        if (this.activeList.getBestToken() != null) {
            ActiveList activeList = this.undoLastGrowStep();
            if (!this.streamEnd) {
                result = new Result(activeList, this.resultList, this.currentFrameNumber, bl, this.linguist.getSearchGraph().getWordTokenFirst(), false);
            }
        }
        if (this.showTokenCount) {
            this.showTokenCount();
        }
        return result;
    }

    protected ActiveList undoLastGrowStep() {
        ActiveList activeList = this.activeList.newInstance();
        for (Token token : this.activeList) {
            Token token2 = token.getPredecessor();
            while (token2.getPredecessor() != null && (token2.isFinal() && token2.getPredecessor() != null && !token2.getPredecessor().isFinal() || token2.isEmitting() && token2.getData() == null || !token2.isFinal() && !token2.isEmitting())) {
                token2 = token2.getPredecessor();
            }
            activeList.add(token2);
        }
        return activeList;
    }

    @Override
    public void stopRecognition() {
        this.localStop();
        this.scorer.stopRecognition();
        this.pruner.stopRecognition();
        this.linguist.stopRecognition();
        this.logger.finer("recognition stopped");
    }

    protected boolean recognize() {
        boolean bl = this.scoreTokens();
        if (bl) {
            this.pruneBranches();
            ++this.currentFrameNumber;
            if (this.growSkipInterval == 0 || this.currentFrameNumber % this.growSkipInterval != 0) {
                this.growBranches();
            }
        }
        return !bl;
    }

    protected void localStart() {
        this.currentFrameNumber = 0;
        this.curTokensScored.value = 0.0;
        ActiveList activeList = this.activeListFactory.newInstance();
        SearchState searchState = this.linguist.getSearchGraph().getInitialState();
        activeList.add(new Token(searchState, -1L));
        this.activeList = activeList;
        this.growBranches();
    }

    protected void localStop() {
    }

    protected void growBranches() {
        int n = this.activeList.size() * 10;
        if (n == 0) {
            n = 1;
        }
        this.growTimer.start();
        this.bestTokenMap = new HashMap<SearchState, Token>(n);
        ActiveList activeList = this.activeList;
        this.resultList = new LinkedList<Token>();
        this.activeList = this.activeListFactory.newInstance();
        this.threshold = activeList.getBeamThreshold();
        this.wordThreshold = activeList.getBestScore() + this.logRelativeWordBeamWidth;
        for (Token token : activeList) {
            this.collectSuccessorTokens(token);
        }
        this.growTimer.stop();
        if (this.logger.isLoggable(Level.FINE)) {
            int n2 = this.activeList.size();
            this.totalHmms += n2;
            this.logger.fine("Frame: " + this.currentFrameNumber + " Hmms: " + n2 + "  total " + this.totalHmms);
        }
    }

    protected boolean scoreTokens() {
        boolean bl = false;
        this.scoreTimer.start();
        Data data = this.scorer.calculateScores(this.activeList.getTokens());
        this.scoreTimer.stop();
        Token token = null;
        if (data instanceof Token) {
            token = (Token)data;
        } else if (data == null) {
            this.streamEnd = true;
        }
        if (token != null) {
            bl = true;
            this.currentCollectTime = token.getCollectTime();
            this.activeList.setBestToken(token);
        }
        this.curTokensScored.value += (double)this.activeList.size();
        this.totalTokensScored.value += (double)this.activeList.size();
        this.tokensPerSecond.value = this.totalTokensScored.value / this.getTotalTime();
        return bl;
    }

    private double getTotalTime() {
        return ((double)System.currentTimeMillis() - this.startTime) / 1000.0;
    }

    protected void pruneBranches() {
        int n = this.activeList.size();
        this.pruneTimer.start();
        this.activeList = this.pruner.prune(this.activeList);
        this.beamPruned.value += (double)(n - this.activeList.size());
        this.pruneTimer.stop();
    }

    protected Token getBestToken(SearchState searchState) {
        Token token = this.bestTokenMap.get(searchState);
        if (this.logger.isLoggable(Level.FINER) && token != null) {
            this.logger.finer("BT " + token + " for state " + searchState);
        }
        return token;
    }

    protected Token setBestToken(Token token, SearchState searchState) {
        return this.bestTokenMap.put(searchState, token);
    }

    public ActiveList getActiveList() {
        return this.activeList;
    }

    protected void collectSuccessorTokens(Token token) {
        SearchStateArc[] searchStateArcArray;
        SearchState searchState = token.getSearchState();
        if (token.isFinal()) {
            this.resultList.add(token);
        }
        if (token.getScore() < this.threshold) {
            return;
        }
        if (searchState instanceof WordSearchState && token.getScore() < this.wordThreshold) {
            return;
        }
        for (SearchStateArc searchStateArc : searchStateArcArray = searchState.getSuccessors()) {
            Token token2;
            SearchState searchState2 = searchStateArc.getState();
            float f = token.getScore() + searchStateArc.getProbability();
            if (this.wantEntryPruning && (f < this.threshold || searchState2 instanceof WordSearchState && f < this.wordThreshold)) continue;
            Token token3 = this.getResultListPredecessor(token);
            if (!searchState2.isEmitting()) {
                token2 = new Token(token3, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentCollectTime);
                this.tokensCreated.value += 1.0;
                if (this.isVisited(token2)) continue;
                this.collectSuccessorTokens(token2);
                continue;
            }
            token2 = this.getBestToken(searchState2);
            if (token2 == null) {
                Token token4 = new Token(token3, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentFrameNumber);
                this.tokensCreated.value += 1.0;
                this.setBestToken(token4, searchState2);
                this.activeList.add(token4);
                continue;
            }
            if (token2.getScore() <= f) {
                token2.update(token3, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentCollectTime);
                this.viterbiPruned.value += 1.0;
                continue;
            }
            this.viterbiPruned.value += 1.0;
        }
    }

    private boolean isVisited(Token token) {
        SearchState searchState = token.getSearchState();
        for (token = token.getPredecessor(); token != null && !token.isEmitting(); token = token.getPredecessor()) {
            if (!searchState.equals(token.getSearchState())) continue;
            return true;
        }
        return false;
    }

    protected void showTokenCount() {
        if (this.logger.isLoggable(Level.INFO)) {
            Token token;
            HashSet<Token> hashSet = new HashSet<Token>();
            Iterator<Object> iterator = this.activeList.iterator();
            while (iterator.hasNext()) {
                for (token = (Token)iterator.next(); token != null; token = token.getPredecessor()) {
                    hashSet.add(token);
                }
            }
            this.logger.info("Token Lattice size: " + hashSet.size());
            hashSet = new HashSet();
            iterator = this.resultList.iterator();
            while (iterator.hasNext()) {
                for (token = (Token)iterator.next(); token != null; token = token.getPredecessor()) {
                    hashSet.add(token);
                }
            }
            this.logger.info("Result Lattice size: " + hashSet.size());
        }
    }

    protected Map<SearchState, Token> getBestTokenMap() {
        return this.bestTokenMap;
    }

    protected void setBestTokenMap(Map<SearchState, Token> map) {
        this.bestTokenMap = map;
    }

    public List<Token> getResultList() {
        return this.resultList;
    }

    public int getCurrentFrameNumber() {
        return this.currentFrameNumber;
    }

    public Timer getGrowTimer() {
        return this.growTimer;
    }

    public StatisticsVariable getTokensCreated() {
        return this.tokensCreated;
    }

    @Override
    public void allocate() {
        this.totalTokensScored = StatisticsVariable.getStatisticsVariable("totalTokensScored");
        this.tokensPerSecond = StatisticsVariable.getStatisticsVariable("tokensScoredPerSecond");
        this.curTokensScored = StatisticsVariable.getStatisticsVariable("curTokensScored");
        this.tokensCreated = StatisticsVariable.getStatisticsVariable("tokensCreated");
        this.viterbiPruned = StatisticsVariable.getStatisticsVariable("viterbiPruned");
        this.beamPruned = StatisticsVariable.getStatisticsVariable("beamPruned");
        try {
            this.linguist.allocate();
            this.pruner.allocate();
            this.scorer.allocate();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Allocation of search manager resources failed", iOException);
        }
        this.scoreTimer = TimerPool.getTimer(this, "Score");
        this.pruneTimer = TimerPool.getTimer(this, "Prune");
        this.growTimer = TimerPool.getTimer(this, "Grow");
    }

    @Override
    public void deallocate() {
        try {
            this.scorer.deallocate();
            this.pruner.deallocate();
            this.linguist.deallocate();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Deallocation of search manager resources failed", iOException);
        }
    }

    public String toString() {
        return this.name;
    }
}

