/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SortingActiveListFactory
extends ActiveListFactory {
    public SortingActiveListFactory(int n, double d) {
        super(n, d);
    }

    public SortingActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
    }

    @Override
    public ActiveList newInstance() {
        return new SortingActiveList(this.absoluteBeamWidth, this.logRelativeBeamWidth);
    }

    class SortingActiveList
    implements ActiveList {
        private static final int DEFAULT_SIZE = 1000;
        private final int absoluteBeamWidth;
        private final float logRelativeBeamWidth;
        private Token bestToken;
        private List<Token> tokenList;

        public SortingActiveList(int n, float f) {
            this.absoluteBeamWidth = n;
            this.logRelativeBeamWidth = f;
            int n2 = n > 0 ? n : 1000;
            this.tokenList = new ArrayList<Token>(n2);
        }

        @Override
        public void add(Token token) {
            this.tokenList.add(token);
            if (this.bestToken == null || token.getScore() > this.bestToken.getScore()) {
                this.bestToken = token;
            }
        }

        @Override
        public ActiveList purge() {
            if (this.absoluteBeamWidth > 0 && this.tokenList.size() > this.absoluteBeamWidth) {
                Collections.sort(this.tokenList, Scoreable.COMPARATOR);
                this.tokenList = this.tokenList.subList(0, this.absoluteBeamWidth);
            }
            return this;
        }

        @Override
        public float getBeamThreshold() {
            return this.getBestScore() + this.logRelativeBeamWidth;
        }

        @Override
        public float getBestScore() {
            float f = -3.4028235E38f;
            if (this.bestToken != null) {
                f = this.bestToken.getScore();
            }
            return f;
        }

        @Override
        public void setBestToken(Token token) {
            this.bestToken = token;
        }

        @Override
        public Token getBestToken() {
            return this.bestToken;
        }

        @Override
        public Iterator<Token> iterator() {
            return this.tokenList.iterator();
        }

        @Override
        public List<Token> getTokens() {
            return this.tokenList;
        }

        @Override
        public final int size() {
            return this.tokenList.size();
        }

        @Override
        public ActiveList newInstance() {
            return SortingActiveListFactory.this.newInstance();
        }
    }
}

