/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Token
implements Scoreable {
    private static int curCount;
    private static int lastCount;
    private static final DecimalFormat scoreFmt;
    private static final DecimalFormat numFmt;
    private Token predecessor;
    private float logLanguageScore;
    private float logTotalScore;
    private float logInsertionScore;
    private float logAcousticScore;
    private SearchState searchState;
    private long collectTime;
    private Data data;

    public Token(Token token, SearchState searchState, float f, float f2, float f3, long l) {
        this.predecessor = token;
        this.searchState = searchState;
        this.logTotalScore = f;
        this.logInsertionScore = f2;
        this.logLanguageScore = f3;
        this.collectTime = l;
        ++curCount;
    }

    public Token(SearchState searchState, long l) {
        this(null, searchState, 0.0f, 0.0f, 0.0f, l);
    }

    public Token(Token token, float f, float f2, float f3, float f4) {
        this(token, null, f, f3, f4, 0L);
        this.logAcousticScore = f2;
    }

    public Token getPredecessor() {
        return this.predecessor;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public void setData(Data data) {
        this.data = data;
        if (data instanceof FloatData) {
            this.collectTime = ((FloatData)data).getCollectTime();
        }
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public float getScore() {
        return this.logTotalScore;
    }

    @Override
    public float calculateScore(Data data) {
        this.logAcousticScore = ((ScoreProvider)((Object)this.searchState)).getScore(data);
        this.logTotalScore += this.logAcousticScore;
        this.setData(data);
        return this.logTotalScore;
    }

    public float[] calculateComponentScore(Data data) {
        return ((ScoreProvider)((Object)this.searchState)).getComponentScore(data);
    }

    @Override
    public float normalizeScore(float f) {
        this.logTotalScore -= f;
        this.logAcousticScore -= f;
        return this.logTotalScore;
    }

    public void setScore(float f) {
        this.logTotalScore = f;
    }

    public float getLanguageScore() {
        return this.logLanguageScore;
    }

    public float getInsertionScore() {
        return this.logInsertionScore;
    }

    public float getAcousticScore() {
        return this.logAcousticScore;
    }

    public SearchState getSearchState() {
        return this.searchState;
    }

    public boolean isEmitting() {
        return this.searchState.isEmitting();
    }

    public boolean isFinal() {
        return this.searchState.isFinal();
    }

    public boolean isWord() {
        return this.searchState instanceof WordSearchState;
    }

    public String toString() {
        return numFmt.format(this.getCollectTime()) + ' ' + scoreFmt.format(this.getScore()) + ' ' + scoreFmt.format(this.getAcousticScore()) + ' ' + scoreFmt.format(this.getLanguageScore()) + ' ' + this.getSearchState();
    }

    public void dumpTokenPath() {
        this.dumpTokenPath(true);
    }

    public void dumpTokenPath(boolean bl) {
        Token token;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (token = this; token != null; token = token.getPredecessor()) {
            arrayList.add(token);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            token = (Token)arrayList.get(i);
            if (!bl && token.getSearchState() instanceof HMMSearchState) continue;
            System.out.println("  " + token);
        }
        System.out.println();
    }

    public String getWordPath(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token = this; token != null; token = token.getPredecessor()) {
            if (!token.isWord()) continue;
            WordSearchState wordSearchState = (WordSearchState)token.getSearchState();
            Pronunciation pronunciation = wordSearchState.getPronunciation();
            Word word = wordSearchState.getPronunciation().getWord();
            if (!bl && word.isFiller()) continue;
            if (bl2) {
                stringBuilder.insert(0, ']');
                Unit[] unitArray = pronunciation.getUnits();
                for (int i = unitArray.length - 1; i >= 0; --i) {
                    if (i < unitArray.length - 1) {
                        stringBuilder.insert(0, ',');
                    }
                    stringBuilder.insert(0, unitArray[i].getName());
                }
                stringBuilder.insert(0, '[');
            }
            stringBuilder.insert(0, word.getSpelling());
            stringBuilder.insert(0, ' ');
        }
        return stringBuilder.toString().trim();
    }

    public String getWordPathNoFiller() {
        return this.getWordPath(false, false);
    }

    public String getWordPath() {
        return this.getWordPath(true, false);
    }

    public String getWordUnitPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token = this; token != null; token = token.getPredecessor()) {
            Object object;
            SearchState searchState;
            SearchState searchState2 = token.getSearchState();
            if (searchState2 instanceof WordSearchState) {
                searchState = (WordSearchState)searchState2;
                object = searchState.getPronunciation().getWord();
                stringBuilder.insert(0, ' ' + ((Word)object).getSpelling());
                continue;
            }
            if (!(searchState2 instanceof UnitSearchState)) continue;
            searchState = (UnitSearchState)searchState2;
            object = searchState.getUnit();
            stringBuilder.insert(0, ' ' + ((Unit)object).getName());
        }
        return stringBuilder.toString().trim();
    }

    public Word getWord() {
        if (this.isWord()) {
            WordSearchState wordSearchState = (WordSearchState)this.searchState;
            return wordSearchState.getPronunciation().getWord();
        }
        return null;
    }

    public static void showCount() {
        System.out.println("Cur count: " + curCount + " new " + (curCount - lastCount));
        lastCount = curCount;
    }

    public boolean validate() {
        return true;
    }

    protected static DecimalFormat getScoreFormat() {
        return scoreFmt;
    }

    protected static DecimalFormat getNumberFormat() {
        return numFmt;
    }

    public void update(Token token, SearchState searchState, float f, float f2, float f3, long l) {
        this.predecessor = token;
        this.searchState = searchState;
        this.logTotalScore = f;
        this.logInsertionScore = f2;
        this.logLanguageScore = f3;
        this.collectTime = l;
    }

    static {
        scoreFmt = new DecimalFormat("0.0000000E00");
        numFmt = new DecimalFormat("0000");
    }
}

