/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.WordPruningBreadthFirstSearchManager;
import edu.cmu.sphinx.linguist.SearchState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TokenHeapSearchManager
extends WordPruningBreadthFirstSearchManager {
    protected final int maxTokenHeapSize = 3;
    Map<Object, TokenHeap> bestTokenMap;

    @Override
    protected void createBestTokenMap() {
        int n = this.activeList.size() << 2;
        if (n == 0) {
            n = 1;
        }
        this.bestTokenMap = new HashMap<Object, TokenHeap>(n, 0.3f);
    }

    @Override
    protected void setBestToken(Token token, SearchState searchState) {
        TokenHeap tokenHeap = this.bestTokenMap.get(searchState);
        if (tokenHeap == null) {
            tokenHeap = new TokenHeap(3);
            this.bestTokenMap.put(searchState, tokenHeap);
        }
        tokenHeap.add(token);
    }

    @Override
    protected Token getBestToken(SearchState searchState) {
        TokenHeap tokenHeap = this.bestTokenMap.get(searchState);
        if (tokenHeap == null) {
            return null;
        }
        Token token = tokenHeap.get(searchState);
        if (token != null) {
            return token;
        }
        if (!tokenHeap.isFull()) {
            return null;
        }
        return tokenHeap.getSmallest();
    }

    class TokenHeap {
        final Token[] tokens;
        int curSize;

        TokenHeap(int n) {
            this.tokens = new Token[n];
        }

        void add(Token token) {
            if (!this.tryReplace(token)) {
                if (this.curSize < this.tokens.length) {
                    this.tokens[this.curSize++] = token;
                } else if (token.getScore() > this.tokens[this.curSize - 1].getScore()) {
                    this.tokens[this.curSize - 1] = token;
                }
            }
            this.fixupInsert();
        }

        Token getSmallest() {
            if (this.curSize == 0) {
                return null;
            }
            return this.tokens[this.curSize - 1];
        }

        boolean isFull() {
            return this.curSize == this.tokens.length;
        }

        private boolean tryReplace(Token token) {
            for (int i = 0; i < this.curSize; ++i) {
                if (!token.getSearchState().equals(this.tokens[i].getSearchState())) continue;
                assert (token.getScore() > this.tokens[i].getScore());
                this.tokens[i] = token;
                return true;
            }
            return false;
        }

        private void fixupInsert() {
            Arrays.sort(this.tokens, 0, this.curSize - 1, Scoreable.COMPARATOR);
        }

        Token get(SearchState searchState) {
            for (int i = 0; i < this.curSize; ++i) {
                if (!this.tokens[i].getSearchState().equals(searchState)) continue;
                return this.tokens[i];
            }
            return null;
        }
    }
}

