/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;

public abstract class TokenSearchManager
implements SearchManager {
    @S4Boolean(defaultValue=true)
    public static final String PROP_BUILD_WORD_LATTICE = "buildWordLattice";
    @S4Boolean(defaultValue=false)
    public static final String PROP_KEEP_ALL_TOKENS = "keepAllTokens";
    protected boolean buildWordLattice;
    protected boolean keepAllTokens;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.buildWordLattice = propertySheet.getBoolean(PROP_BUILD_WORD_LATTICE);
        this.keepAllTokens = propertySheet.getBoolean(PROP_KEEP_ALL_TOKENS);
    }

    protected Token getResultListPredecessor(Token token) {
        if (this.keepAllTokens) {
            return token;
        }
        if (!this.buildWordLattice) {
            if (token.isWord()) {
                return token;
            }
            return token.getPredecessor();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (token != null && !token.isWord()) {
            f += token.getAcousticScore();
            f2 += token.getLanguageScore();
            f3 += token.getInsertionScore();
            token = token.getPredecessor();
        }
        return new Token(token, token.getScore(), f3, f, f2);
    }
}

