/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WordActiveListFactory
extends ActiveListFactory {
    @S4Integer(defaultValue=0)
    public static final String PROP_MAX_PATHS_PER_WORD = "maxPathsPerWord";
    @S4Integer(defaultValue=1)
    public static final String PROP_MAX_FILLER_WORDS = "maxFillerWords";
    private int maxPathsPerWord;
    private int maxFiller;

    public WordActiveListFactory(int n, double d, int n2, int n3) {
        super(n, d);
        this.maxPathsPerWord = n2;
        this.maxFiller = n3;
    }

    public WordActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.maxPathsPerWord = propertySheet.getInt(PROP_MAX_PATHS_PER_WORD);
        this.maxFiller = propertySheet.getInt(PROP_MAX_FILLER_WORDS);
    }

    @Override
    public ActiveList newInstance() {
        return new WordActiveList();
    }

    class WordActiveList
    implements ActiveList {
        private Token bestToken;
        private List<Token> tokenList = new LinkedList<Token>();

        WordActiveList() {
        }

        @Override
        public void add(Token token) {
            this.tokenList.add(token);
            if (this.bestToken == null || token.getScore() > this.bestToken.getScore()) {
                this.bestToken = token;
            }
        }

        public void replace(Token token, Token token2) {
            this.add(token2);
            if (token != null) {
                this.tokenList.remove(token);
            }
        }

        @Override
        public ActiveList purge() {
            int n = 0;
            HashMap<Word, Integer> hashMap = new HashMap<Word, Integer>();
            Collections.sort(this.tokenList, Scoreable.COMPARATOR);
            Iterator<Token> iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                int n2;
                Token token = iterator.next();
                WordSearchState wordSearchState = (WordSearchState)token.getSearchState();
                Word word = wordSearchState.getPronunciation().getWord();
                if (WordActiveListFactory.this.maxFiller > 0 && word.isFiller()) {
                    if (n < WordActiveListFactory.this.maxFiller) {
                        ++n;
                    } else {
                        iterator.remove();
                        continue;
                    }
                }
                if (WordActiveListFactory.this.maxPathsPerWord <= 0) continue;
                Integer n3 = (Integer)hashMap.get(word);
                int n4 = n2 = n3 == null ? 0 : n3;
                if (n2 < WordActiveListFactory.this.maxPathsPerWord - 1) {
                    hashMap.put(word, n2 + 1);
                    continue;
                }
                iterator.remove();
            }
            if (this.tokenList.size() > WordActiveListFactory.this.absoluteBeamWidth) {
                this.tokenList = this.tokenList.subList(0, WordActiveListFactory.this.absoluteBeamWidth);
            }
            return this;
        }

        @Override
        public Iterator<Token> iterator() {
            return this.tokenList.iterator();
        }

        @Override
        public List<Token> getTokens() {
            return this.tokenList;
        }

        @Override
        public final int size() {
            return this.tokenList.size();
        }

        @Override
        public float getBeamThreshold() {
            return this.getBestScore() + WordActiveListFactory.this.logRelativeBeamWidth;
        }

        @Override
        public float getBestScore() {
            float f = -3.4028235E38f;
            if (this.bestToken != null) {
                f = this.bestToken.getScore();
            }
            return f;
        }

        @Override
        public void setBestToken(Token token) {
            this.bestToken = token;
        }

        @Override
        public Token getBestToken() {
            return this.bestToken;
        }

        @Override
        public ActiveList newInstance() {
            return WordActiveListFactory.this.newInstance();
        }
    }
}

