/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.ActiveListManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.WordPruningBreadthFirstSearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import edu.cmu.sphinx.linguist.allphone.PhoneHmmSearchState;
import edu.cmu.sphinx.linguist.lextree.LexTreeLinguist;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class WordPruningBreadthFirstLookaheadSearchManager
extends WordPruningBreadthFirstSearchManager {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    @S4Component(type=Linguist.class)
    public static final String PROP_FASTMATCH_LINGUIST = "fastmatchLinguist";
    @S4Component(type=ActiveListFactory.class)
    public static final String PROP_FM_ACTIVE_LIST_FACTORY = "fastmatchActiveListFactory";
    @S4Double(defaultValue=1.0)
    public static final String PROP_LOOKAHEAD_PENALTY_WEIGHT = "lookaheadPenaltyWeight";
    @S4Integer(defaultValue=5)
    public static final String PROP_LOOKAHEAD_WINDOW = "lookaheadWindow";
    private Linguist fastmatchLinguist;
    private Loader loader;
    private ActiveListFactory fastmatchActiveListFactory;
    private int lookaheadWindow;
    private float lookaheadWeight;
    private HashMap<Integer, Float> penalties;
    private LinkedList<FrameCiScores> ciScores;
    private int currentFastMatchFrameNumber;
    protected ActiveList fastmatchActiveList;
    protected Map<SearchState, Token> fastMatchBestTokenMap;
    private boolean fastmatchStreamEnd;

    public WordPruningBreadthFirstLookaheadSearchManager(Linguist linguist, Linguist linguist2, Loader loader, Pruner pruner, AcousticScorer acousticScorer, ActiveListManager activeListManager, ActiveListFactory activeListFactory, boolean bl, double d, int n, boolean bl2, boolean bl3, int n2, float f, int n3, float f2, boolean bl4) {
        super(linguist, pruner, acousticScorer, activeListManager, bl, d, n, bl2, bl3, n3, f2, bl4);
        this.loader = loader;
        this.fastmatchLinguist = linguist2;
        this.fastmatchActiveListFactory = activeListFactory;
        this.lookaheadWindow = n2;
        this.lookaheadWeight = f;
        if (n2 < 1 || n2 > 10) {
            throw new IllegalArgumentException("Unsupported lookahead window size: " + n2 + ". Value in range [1..10] is expected");
        }
        this.ciScores = new LinkedList();
        this.penalties = new HashMap();
        if (loader instanceof Sphinx3Loader && ((Sphinx3Loader)loader).hasTiedMixtures()) {
            ((Sphinx3Loader)loader).setGauScoresQueueLength(n2 + 2);
        }
    }

    public WordPruningBreadthFirstLookaheadSearchManager() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.fastmatchLinguist = (Linguist)propertySheet.getComponent(PROP_FASTMATCH_LINGUIST);
        this.fastmatchActiveListFactory = (ActiveListFactory)propertySheet.getComponent(PROP_FM_ACTIVE_LIST_FACTORY);
        this.loader = (Loader)propertySheet.getComponent(PROP_LOADER);
        this.lookaheadWindow = propertySheet.getInt(PROP_LOOKAHEAD_WINDOW);
        this.lookaheadWeight = propertySheet.getFloat(PROP_LOOKAHEAD_PENALTY_WEIGHT);
        if (this.lookaheadWindow < 1 || this.lookaheadWindow > 10) {
            throw new PropertyException(WordPruningBreadthFirstLookaheadSearchManager.class.getName(), PROP_LOOKAHEAD_WINDOW, "Unsupported lookahead window size: " + this.lookaheadWindow + ". Value in range [1..10] is expected");
        }
        this.ciScores = new LinkedList();
        this.penalties = new HashMap();
        if (this.loader instanceof Sphinx3Loader && ((Sphinx3Loader)this.loader).hasTiedMixtures()) {
            ((Sphinx3Loader)this.loader).setGauScoresQueueLength(this.lookaheadWindow + 2);
        }
    }

    @Override
    public Result recognize(int n) {
        boolean bl = false;
        Result result = null;
        this.streamEnd = false;
        for (int i = 0; i < n && !bl; ++i) {
            if (!this.fastmatchStreamEnd) {
                this.fastMatchRecognize();
            }
            this.penalties.clear();
            this.ciScores.poll();
            bl = this.recognize();
        }
        if (!this.streamEnd) {
            result = new Result(this.loserManager, this.activeList, this.resultList, this.currentCollectTime, bl, this.linguist.getSearchGraph().getWordTokenFirst(), true);
        }
        if (this.showTokenCount) {
            this.showTokenCount();
        }
        return result;
    }

    private void fastMatchRecognize() {
        boolean bl = this.scoreFastMatchTokens();
        if (bl) {
            this.pruneFastMatchBranches();
            ++this.currentFastMatchFrameNumber;
            this.createFastMatchBestTokenMap();
            this.growFastmatchBranches();
        }
    }

    protected void createFastMatchBestTokenMap() {
        int n = this.fastmatchActiveList.size() * 10;
        if (n == 0) {
            n = 1;
        }
        this.fastMatchBestTokenMap = new HashMap<SearchState, Token>(n);
    }

    @Override
    protected void localStart() {
        this.currentFastMatchFrameNumber = 0;
        if (this.loader instanceof Sphinx3Loader && ((Sphinx3Loader)this.loader).hasTiedMixtures()) {
            ((Sphinx3Loader)this.loader).clearGauScores();
        }
        this.fastmatchActiveList = this.fastmatchActiveListFactory.newInstance();
        SearchState searchState = this.fastmatchLinguist.getSearchGraph().getInitialState();
        this.fastmatchActiveList.add(new Token(searchState, this.currentFastMatchFrameNumber));
        this.createFastMatchBestTokenMap();
        this.growFastmatchBranches();
        this.fastmatchStreamEnd = false;
        for (int i = 0; i < this.lookaheadWindow - 1 && !this.fastmatchStreamEnd; ++i) {
            this.fastMatchRecognize();
        }
        super.localStart();
    }

    protected void growFastmatchBranches() {
        this.growTimer.start();
        ActiveList activeList = this.fastmatchActiveList;
        this.fastmatchActiveList = this.fastmatchActiveListFactory.newInstance();
        float f = activeList.getBeamThreshold();
        float[] fArray = new float[100];
        Arrays.fill(fArray, -3.4028235E38f);
        float f2 = -3.4028235E38f;
        for (Token token : activeList) {
            float f3 = token.getScore();
            if (f3 < f) continue;
            if (token.getSearchState() instanceof PhoneHmmSearchState) {
                int n = ((PhoneHmmSearchState)token.getSearchState()).getBaseId();
                if (fArray[n] < f3) {
                    fArray[n] = f3;
                }
                if (f2 < f3) {
                    f2 = f3;
                }
            }
            this.collectFastMatchSuccessorTokens(token);
        }
        this.ciScores.add(new FrameCiScores(fArray, f2));
        this.growTimer.stop();
    }

    protected boolean scoreFastMatchTokens() {
        this.scoreTimer.start();
        Data data = this.scorer.calculateScoresAndStoreData(this.fastmatchActiveList.getTokens());
        this.scoreTimer.stop();
        Token token = null;
        if (data instanceof Token) {
            token = (Token)data;
        } else {
            this.fastmatchStreamEnd = true;
        }
        boolean bl = token != null;
        this.fastmatchActiveList.setBestToken(token);
        this.monitorStates(this.fastmatchActiveList);
        this.curTokensScored.value += (double)this.fastmatchActiveList.size();
        this.totalTokensScored.value += (double)this.fastmatchActiveList.size();
        return bl;
    }

    protected void pruneFastMatchBranches() {
        this.pruneTimer.start();
        this.fastmatchActiveList = this.pruner.prune(this.fastmatchActiveList);
        this.pruneTimer.stop();
    }

    protected Token getFastMatchBestToken(SearchState searchState) {
        return this.fastMatchBestTokenMap.get(searchState);
    }

    protected void setFastMatchBestToken(Token token, SearchState searchState) {
        this.fastMatchBestTokenMap.put(searchState, token);
    }

    protected void collectFastMatchSuccessorTokens(Token token) {
        SearchStateArc[] searchStateArcArray;
        SearchState searchState = token.getSearchState();
        for (SearchStateArc searchStateArc : searchStateArcArray = searchState.getSuccessors()) {
            Token token2;
            SearchState searchState2 = searchStateArc.getState();
            float f = token.getScore() + searchStateArc.getProbability();
            Token token3 = this.getResultListPredecessor(token);
            if (!searchState2.isEmitting()) {
                token2 = new Token(token3, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentFastMatchFrameNumber);
                this.tokensCreated.value += 1.0;
                if (this.isVisited(token2)) continue;
                this.collectFastMatchSuccessorTokens(token2);
                continue;
            }
            token2 = this.getFastMatchBestToken(searchState2);
            if (token2 == null) {
                Token token4 = new Token(token3, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentFastMatchFrameNumber);
                this.tokensCreated.value += 1.0;
                this.setFastMatchBestToken(token4, searchState2);
                this.fastmatchActiveList.add(token4);
                continue;
            }
            if (!(token2.getScore() <= f)) continue;
            token2.update(token3, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentFastMatchFrameNumber);
        }
    }

    @Override
    protected void collectSuccessorTokens(Token token) {
        if (token.isFinal()) {
            this.resultList.add(this.getResultListPredecessor(token));
            return;
        }
        if (!token.isEmitting() && this.keepAllTokens && this.isVisited(token)) {
            return;
        }
        SearchState searchState = token.getSearchState();
        SearchStateArc[] searchStateArcArray = searchState.getSuccessors();
        Token token2 = this.getResultListPredecessor(token);
        float f = token.getScore();
        float f2 = this.activeList.getBeamThreshold();
        boolean bl = searchState instanceof LexTreeLinguist.LexTreeNonEmittingHMMState || searchState instanceof LexTreeLinguist.LexTreeWordState || searchState instanceof LexTreeLinguist.LexTreeEndUnitState;
        for (SearchStateArc searchStateArc : searchStateArcArray) {
            Token token3;
            SearchState searchState2 = searchStateArc.getState();
            if (bl && searchState2 instanceof LexTreeLinguist.LexTreeHMMState) {
                int n = ((LexTreeLinguist.LexTreeHMMState)searchState2).getHMMState().getHMM().getBaseUnit().getBaseID();
                Float f3 = this.penalties.get(n);
                if (f3 == null) {
                    f3 = this.updateLookaheadPenalty(n);
                }
                if (f + this.lookaheadWeight * f3.floatValue() < f2) continue;
            }
            if (this.checkStateOrder) {
                this.checkStateOrder(searchState, searchState2);
            }
            float f4 = f + searchStateArc.getProbability();
            Token token4 = this.getBestToken(searchState2);
            if (token4 == null) {
                token3 = new Token(token2, searchState2, f4, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentCollectTime);
                this.tokensCreated.value += 1.0;
                this.setBestToken(token3, searchState2);
                this.activeListAdd(token3);
                continue;
            }
            if (token4.getScore() < f4) {
                token3 = token4.getPredecessor();
                token4.update(token2, searchState2, f4, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentCollectTime);
                if (!this.buildWordLattice || !(searchState2 instanceof WordSearchState)) continue;
                this.loserManager.addAlternatePredecessor(token4, token3);
                continue;
            }
            if (!this.buildWordLattice || !(searchState2 instanceof WordSearchState) || token2 == null) continue;
            this.loserManager.addAlternatePredecessor(token4, token2);
        }
    }

    private Float updateLookaheadPenalty(int n) {
        if (this.ciScores.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        float f = -3.4028235E38f;
        for (FrameCiScores frameCiScores : this.ciScores) {
            float f2 = frameCiScores.scores[n] - frameCiScores.maxScore;
            if (!(f2 > f)) continue;
            f = f2;
        }
        this.penalties.put(n, Float.valueOf(f));
        return Float.valueOf(f);
    }

    private class FrameCiScores {
        public final float[] scores;
        public final float maxScore;

        public FrameCiScores(float[] fArray, float f) {
            this.scores = fArray;
            this.maxScore = f;
        }
    }
}

