/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListManager;
import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.TokenSearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WordPruningBreadthFirstSearchManager
extends TokenSearchManager {
    @S4Component(type=Linguist.class)
    public static final String PROP_LINGUIST = "linguist";
    @S4Component(type=Pruner.class)
    public static final String PROP_PRUNER = "pruner";
    @S4Component(type=AcousticScorer.class)
    public static final String PROP_SCORER = "scorer";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_TOKEN_COUNT = "showTokenCount";
    @S4Integer(defaultValue=0)
    public static final String PROP_GROW_SKIP_INTERVAL = "growSkipInterval";
    @S4Component(type=ActiveListManager.class)
    public static final String PROP_ACTIVE_LIST_MANAGER = "activeListManager";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CHECK_STATE_ORDER = "checkStateOrder";
    @S4Integer(defaultValue=100)
    public static final String PROP_MAX_LATTICE_EDGES = "maxLatticeEdges";
    @S4Double(defaultValue=0.0)
    public static final String PROP_ACOUSTIC_LOOKAHEAD_FRAMES = "acousticLookaheadFrames";
    @S4Double(defaultValue=0.0)
    public static final String PROP_RELATIVE_BEAM_WIDTH = "relativeBeamWidth";
    protected Linguist linguist;
    protected Pruner pruner;
    protected AcousticScorer scorer;
    private ActiveListManager activeListManager;
    protected LogMath logMath;
    protected Logger logger;
    protected boolean showTokenCount;
    protected boolean checkStateOrder;
    private int growSkipInterval;
    protected float relativeBeamWidth;
    protected float acousticLookaheadFrames;
    private int maxLatticeEdges = 100;
    protected Timer scoreTimer;
    protected Timer pruneTimer;
    protected Timer growTimer;
    protected StatisticsVariable totalTokensScored;
    protected StatisticsVariable curTokensScored;
    protected StatisticsVariable tokensCreated;
    private long tokenSum;
    private int tokenCount;
    protected int currentFrameNumber;
    protected long currentCollectTime;
    protected ActiveList activeList;
    protected List<Token> resultList;
    protected Map<SearchState, Token> bestTokenMap;
    protected AlternateHypothesisManager loserManager;
    private int numStateOrder;
    protected boolean streamEnd;

    public WordPruningBreadthFirstSearchManager(Linguist linguist, Pruner pruner, AcousticScorer acousticScorer, ActiveListManager activeListManager, boolean bl, double d, int n, boolean bl2, boolean bl3, int n2, float f, boolean bl4) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logMath = LogMath.getLogMath();
        this.linguist = linguist;
        this.pruner = pruner;
        this.scorer = acousticScorer;
        this.activeListManager = activeListManager;
        this.showTokenCount = bl;
        this.growSkipInterval = n;
        this.checkStateOrder = bl2;
        this.buildWordLattice = bl3;
        this.maxLatticeEdges = n2;
        this.acousticLookaheadFrames = f;
        this.keepAllTokens = bl4;
        this.relativeBeamWidth = this.logMath.linearToLog(d);
    }

    public WordPruningBreadthFirstSearchManager() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.logMath = LogMath.getLogMath();
        this.logger = propertySheet.getLogger();
        this.linguist = (Linguist)propertySheet.getComponent(PROP_LINGUIST);
        this.pruner = (Pruner)propertySheet.getComponent(PROP_PRUNER);
        this.scorer = (AcousticScorer)propertySheet.getComponent(PROP_SCORER);
        this.activeListManager = (ActiveListManager)propertySheet.getComponent(PROP_ACTIVE_LIST_MANAGER);
        this.showTokenCount = propertySheet.getBoolean(PROP_SHOW_TOKEN_COUNT);
        this.growSkipInterval = propertySheet.getInt(PROP_GROW_SKIP_INTERVAL);
        this.checkStateOrder = propertySheet.getBoolean(PROP_CHECK_STATE_ORDER);
        this.maxLatticeEdges = propertySheet.getInt(PROP_MAX_LATTICE_EDGES);
        this.acousticLookaheadFrames = propertySheet.getFloat(PROP_ACOUSTIC_LOOKAHEAD_FRAMES);
        this.relativeBeamWidth = this.logMath.linearToLog(propertySheet.getDouble(PROP_RELATIVE_BEAM_WIDTH));
    }

    @Override
    public void allocate() {
        this.scoreTimer = TimerPool.getTimer(this, "Score");
        this.pruneTimer = TimerPool.getTimer(this, "Prune");
        this.growTimer = TimerPool.getTimer(this, "Grow");
        this.totalTokensScored = StatisticsVariable.getStatisticsVariable("totalTokensScored");
        this.curTokensScored = StatisticsVariable.getStatisticsVariable("curTokensScored");
        this.tokensCreated = StatisticsVariable.getStatisticsVariable("tokensCreated");
        try {
            this.linguist.allocate();
            this.pruner.allocate();
            this.scorer.allocate();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Allocation of search manager resources failed", iOException);
        }
    }

    @Override
    public void deallocate() {
        try {
            this.scorer.deallocate();
            this.pruner.deallocate();
            this.linguist.deallocate();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Deallocation of search manager resources failed", iOException);
        }
    }

    @Override
    public void startRecognition() {
        this.linguist.startRecognition();
        this.pruner.startRecognition();
        this.scorer.startRecognition();
        this.localStart();
    }

    @Override
    public Result recognize(int n) {
        boolean bl = false;
        Result result = null;
        this.streamEnd = false;
        for (int i = 0; i < n && !bl; ++i) {
            bl = this.recognize();
        }
        if (!this.streamEnd) {
            result = new Result(this.loserManager, this.activeList, this.resultList, this.currentCollectTime, bl, this.linguist.getSearchGraph().getWordTokenFirst(), true);
        }
        if (this.showTokenCount) {
            this.showTokenCount();
        }
        return result;
    }

    protected boolean recognize() {
        this.activeList = this.activeListManager.getEmittingList();
        boolean bl = this.scoreTokens();
        if (bl) {
            this.pruneBranches();
            ++this.currentFrameNumber;
            if (this.growSkipInterval == 0 || this.currentFrameNumber % this.growSkipInterval != 0) {
                this.clearCollectors();
                this.growEmittingBranches();
                this.growNonEmittingBranches();
            }
        }
        return !bl;
    }

    private void clearCollectors() {
        this.resultList = new LinkedList<Token>();
        this.createBestTokenMap();
        this.activeListManager.clearEmittingList();
    }

    protected void createBestTokenMap() {
        int n = this.activeList.size() * 10;
        if (n == 0) {
            n = 1;
        }
        this.bestTokenMap = new HashMap<SearchState, Token>(n, 0.3f);
    }

    @Override
    public void stopRecognition() {
        this.localStop();
        this.scorer.stopRecognition();
        this.pruner.stopRecognition();
        this.linguist.stopRecognition();
    }

    protected void localStart() {
        SearchGraph searchGraph = this.linguist.getSearchGraph();
        this.currentFrameNumber = 0;
        this.curTokensScored.value = 0.0;
        this.numStateOrder = searchGraph.getNumStateOrder();
        this.activeListManager.setNumStateOrder(this.numStateOrder);
        if (this.buildWordLattice) {
            this.loserManager = new AlternateHypothesisManager(this.maxLatticeEdges);
        }
        SearchState searchState = searchGraph.getInitialState();
        this.activeList = this.activeListManager.getEmittingList();
        this.activeList.add(new Token(searchState, -1L));
        this.clearCollectors();
        this.growBranches();
        this.growNonEmittingBranches();
    }

    protected void localStop() {
    }

    protected void growBranches() {
        this.growTimer.start();
        float f = this.activeList.getBeamThreshold();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Frame: " + this.currentFrameNumber + " thresh : " + f + " bs " + this.activeList.getBestScore() + " tok " + this.activeList.getBestToken());
        }
        for (Token token : this.activeList) {
            if (!(token.getScore() >= f) || !this.allowExpansion(token)) continue;
            this.collectSuccessorTokens(token);
        }
        this.growTimer.stop();
    }

    protected void growEmittingBranches() {
        if (this.acousticLookaheadFrames <= 0.0f) {
            this.growBranches();
            return;
        }
        this.growTimer.start();
        float f = -3.4028235E38f;
        for (Object object : this.activeList) {
            float f2 = ((Token)object).getScore() + ((Token)object).getAcousticScore() * this.acousticLookaheadFrames;
            if (!(f2 > f)) continue;
            f = f2;
        }
        float f3 = f + this.relativeBeamWidth;
        for (Token token : this.activeList) {
            if (!(token.getScore() + token.getAcousticScore() * this.acousticLookaheadFrames > f3)) continue;
            this.collectSuccessorTokens(token);
        }
        this.growTimer.stop();
    }

    private void growNonEmittingBranches() {
        Iterator<ActiveList> iterator = this.activeListManager.getNonEmittingListIterator();
        while (iterator.hasNext()) {
            this.activeList = iterator.next();
            if (this.activeList == null) continue;
            iterator.remove();
            this.pruneBranches();
            this.growBranches();
        }
    }

    protected boolean scoreTokens() {
        this.scoreTimer.start();
        Data data = this.scorer.calculateScores(this.activeList.getTokens());
        this.scoreTimer.stop();
        Token token = null;
        if (data instanceof Token) {
            token = (Token)data;
        } else if (data == null) {
            this.streamEnd = true;
        }
        if (token != null) {
            this.currentCollectTime = token.getCollectTime();
        }
        boolean bl = token != null;
        this.activeList.setBestToken(token);
        this.monitorStates(this.activeList);
        this.curTokensScored.value += (double)this.activeList.size();
        this.totalTokensScored.value += (double)this.activeList.size();
        return bl;
    }

    private void monitorWords(ActiveList activeList) {
    }

    protected void monitorStates(ActiveList activeList) {
        this.tokenSum += (long)activeList.size();
        ++this.tokenCount;
        if (this.tokenCount % 1000 == 0) {
            this.logger.info("Average Tokens/State: " + this.tokenSum / (long)this.tokenCount);
        }
    }

    protected void pruneBranches() {
        this.pruneTimer.start();
        this.activeList = this.pruner.prune(this.activeList);
        this.pruneTimer.stop();
    }

    protected Token getBestToken(SearchState searchState) {
        return this.bestTokenMap.get(searchState);
    }

    protected void setBestToken(Token token, SearchState searchState) {
        this.bestTokenMap.put(searchState, token);
    }

    protected void checkStateOrder(SearchState searchState, SearchState searchState2) {
        if (searchState.getOrder() == this.numStateOrder - 1) {
            return;
        }
        if (searchState.getOrder() > searchState2.getOrder()) {
            throw new Error("IllegalState order: from " + searchState.getClass().getName() + ' ' + searchState.toPrettyString() + " order: " + searchState.getOrder() + " to " + searchState2.getClass().getName() + ' ' + searchState2.toPrettyString() + " order: " + searchState2.getOrder());
        }
    }

    protected void collectSuccessorTokens(Token token) {
        if (token.isFinal()) {
            this.resultList.add(this.getResultListPredecessor(token));
            return;
        }
        if (!token.isEmitting() && this.keepAllTokens && this.isVisited(token)) {
            return;
        }
        SearchState searchState = token.getSearchState();
        SearchStateArc[] searchStateArcArray = searchState.getSuccessors();
        Token token2 = this.getResultListPredecessor(token);
        for (SearchStateArc searchStateArc : searchStateArcArray) {
            Token token3;
            SearchState searchState2 = searchStateArc.getState();
            if (this.checkStateOrder) {
                this.checkStateOrder(searchState, searchState2);
            }
            float f = token.getScore() + searchStateArc.getProbability();
            Token token4 = this.getBestToken(searchState2);
            if (token4 == null) {
                token3 = new Token(token2, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentCollectTime);
                this.tokensCreated.value += 1.0;
                this.setBestToken(token3, searchState2);
                this.activeListAdd(token3);
                continue;
            }
            if (token4.getScore() < f) {
                token3 = token4.getPredecessor();
                token4.update(token2, searchState2, f, searchStateArc.getInsertionProbability(), searchStateArc.getLanguageProbability(), this.currentCollectTime);
                if (!this.buildWordLattice || !(searchState2 instanceof WordSearchState)) continue;
                this.loserManager.addAlternatePredecessor(token4, token3);
                continue;
            }
            if (!this.buildWordLattice || !(searchState2 instanceof WordSearchState) || token2 == null) continue;
            this.loserManager.addAlternatePredecessor(token4, token2);
        }
    }

    protected boolean isVisited(Token token) {
        SearchState searchState = token.getSearchState();
        for (token = token.getPredecessor(); token != null && !token.isEmitting(); token = token.getPredecessor()) {
            if (!searchState.equals(token.getSearchState())) continue;
            System.out.println("CS " + searchState + " match " + token.getSearchState());
            return true;
        }
        return false;
    }

    protected void activeListAdd(Token token) {
        this.activeListManager.add(token);
    }

    protected boolean allowExpansion(Token token) {
        return true;
    }

    protected void showTokenCount() {
        Token token;
        HashSet<Token> hashSet = new HashSet<Token>();
        Iterator<Object> iterator = this.activeList.iterator();
        while (iterator.hasNext()) {
            for (token = (Token)iterator.next(); token != null; token = token.getPredecessor()) {
                hashSet.add(token);
            }
        }
        System.out.println("Token Lattice size: " + hashSet.size());
        hashSet = new HashSet();
        iterator = this.resultList.iterator();
        while (iterator.hasNext()) {
            for (token = (Token)iterator.next(); token != null; token = token.getPredecessor()) {
                hashSet.add(token);
            }
        }
        System.out.println("Result Lattice size: " + hashSet.size());
    }

    public ActiveList getActiveList() {
        return this.activeList;
    }

    public void setActiveList(ActiveList activeList) {
        this.activeList = activeList;
    }

    public List<Token> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<Token> list) {
        this.resultList = list;
    }

    public int getCurrentFrameNumber() {
        return this.currentFrameNumber;
    }

    public Timer getGrowTimer() {
        return this.growTimer;
    }

    public StatisticsVariable getTokensCreated() {
        return this.tokensCreated;
    }
}

