/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search.stats;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.WordSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StateHistoryTracker {
    final Map<WordSequence, WordStats> statMap = new HashMap<WordSequence, WordStats>();
    final int frameNumber;
    int stateCount;
    int maxWordHistories;

    public StateHistoryTracker(int n) {
        this.frameNumber = n;
    }

    public void add(Token token) {
        ++this.stateCount;
        WordSequence wordSequence = this.getWordSequence(token);
        WordStats wordStats = this.statMap.get(wordSequence);
        if (wordStats == null) {
            wordStats = new WordStats(wordSequence);
            this.statMap.put(wordSequence, wordStats);
        }
        wordStats.update(token);
    }

    public void dump() {
        this.dumpSummary();
        ArrayList<WordStats> arrayList = new ArrayList<WordStats>(this.statMap.values());
        Collections.sort(arrayList, WordStats.COMPARATOR);
        for (WordStats wordStats : arrayList) {
            System.out.println("   " + wordStats);
        }
    }

    void dumpSummary() {
        System.out.println("Frame: " + this.frameNumber + " states: " + this.stateCount + " histories " + this.statMap.size());
    }

    private WordSequence getWordSequence(Token token) {
        return token.getSearchState().getWordHistory();
    }

    static class WordStats {
        public static final Comparator<WordStats> COMPARATOR = new Comparator<WordStats>(){

            @Override
            public int compare(WordStats wordStats, WordStats wordStats2) {
                if (wordStats.maxScore > wordStats2.maxScore) {
                    return -1;
                }
                if (wordStats.maxScore == wordStats2.maxScore) {
                    return 0;
                }
                return 1;
            }
        };
        private int size = 0;
        private float maxScore = -3.4028235E38f;
        private float minScore = Float.MAX_VALUE;
        private final WordSequence ws;

        WordStats(WordSequence wordSequence) {
            this.ws = wordSequence;
        }

        void update(Token token) {
            ++this.size;
            if (token.getScore() > this.maxScore) {
                this.maxScore = token.getScore();
            }
            if (token.getScore() < this.minScore) {
                this.minScore = token.getScore();
            }
        }

        public String toString() {
            return "states:" + this.size + " max:" + this.maxScore + " min:" + this.minScore + ' ' + this.ws;
        }
    }
}

