/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search.stats;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.HMMSearchState;
import java.util.HashMap;
import java.util.Map;

public class TokenTracker {
    private Map<Object, TokenStats> stateMap;
    private boolean enabled;
    private int frame;
    private int utteranceStateCount;
    private int utteranceMaxStates;
    private int utteranceSumStates;

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    void startUtterance() {
        if (this.enabled) {
            this.frame = 0;
            this.utteranceStateCount = 0;
            this.utteranceMaxStates = -2147483647;
            this.utteranceSumStates = 0;
        }
    }

    void stopUtterance() {
        if (this.enabled) {
            this.dumpSummary();
        }
    }

    void startFrame() {
        if (this.enabled) {
            this.stateMap = new HashMap<Object, TokenStats>();
        }
    }

    public void add(Token token) {
        if (this.enabled) {
            TokenStats tokenStats = this.getStats(token);
            tokenStats.update(token);
        }
    }

    void stopFrame() {
        if (this.enabled) {
            ++this.frame;
            this.dumpDetails();
        }
    }

    public void dumpSummary() {
        if (this.enabled) {
            float f = 0.0f;
            if (this.utteranceStateCount > 0) {
                f = (float)this.utteranceSumStates / (float)this.utteranceStateCount;
            }
            System.out.print("# Utterance stats ");
            System.out.print(" States: " + this.utteranceStateCount / this.frame);
            if (this.utteranceStateCount > 0) {
                System.out.print(" Paths: " + this.utteranceSumStates / this.frame);
                System.out.print(" Max: " + this.utteranceMaxStates);
                System.out.print(" Avg: " + f);
            }
            System.out.println();
        }
    }

    public void dumpDetails() {
        if (this.enabled) {
            int n = -2147483647;
            int n2 = 0;
            int n3 = 0;
            for (TokenStats tokenStats : this.stateMap.values()) {
                if (tokenStats.isHMM) {
                    ++n2;
                }
                n3 += tokenStats.count;
                this.utteranceSumStates += tokenStats.count;
                if (tokenStats.count > n) {
                    n = tokenStats.count;
                }
                if (tokenStats.count <= this.utteranceMaxStates) continue;
                this.utteranceMaxStates = tokenStats.count;
            }
            this.utteranceStateCount += this.stateMap.size();
            float f = 0.0f;
            if (!this.stateMap.isEmpty()) {
                f = (float)n3 / (float)this.stateMap.size();
            }
            System.out.print("# Frame " + this.frame);
            System.out.print(" States: " + this.stateMap.size());
            if (!this.stateMap.isEmpty()) {
                System.out.print(" Paths: " + n3);
                System.out.print(" Max: " + n);
                System.out.print(" Avg: " + f);
                System.out.print(" HMM: " + n2);
            }
            System.out.println();
        }
    }

    private TokenStats getStats(Token token) {
        TokenStats tokenStats = this.stateMap.get(token.getSearchState().getLexState());
        if (tokenStats == null) {
            tokenStats = new TokenStats();
            this.stateMap.put(token.getSearchState().getLexState(), tokenStats);
        }
        return tokenStats;
    }

    class TokenStats {
        int count = 0;
        float maxScore = -3.4028235E38f;
        float minScore = Float.MIN_VALUE;
        boolean isHMM;

        TokenStats() {
        }

        public void update(Token token) {
            ++this.count;
            if (token.getScore() > this.maxScore) {
                this.maxScore = token.getScore();
            }
            if (token.getScore() < this.minScore) {
                this.minScore = token.getScore();
            }
            this.isHMM = token.getSearchState() instanceof HMMSearchState;
        }
    }
}

