/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search.stats;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.acoustic.HMM;

public class TokenTypeTracker {
    private int numWords;
    private int numUnits;
    private int numOthers;
    private int numHMMBegin;
    private int numHMMEnd;
    private int numHMMSingle;
    private int numHMMInternal;
    private int numTokens;

    public void add(Token token) {
        ++this.numTokens;
        SearchState searchState = token.getSearchState();
        if (searchState instanceof WordSearchState) {
            ++this.numWords;
        } else if (searchState instanceof UnitSearchState) {
            ++this.numUnits;
        } else if (searchState instanceof HMMSearchState) {
            HMM hMM = ((HMMSearchState)searchState).getHMMState().getHMM();
            switch (hMM.getPosition()) {
                case BEGIN: {
                    ++this.numHMMBegin;
                    break;
                }
                case END: {
                    ++this.numHMMEnd;
                    break;
                }
                case SINGLE: {
                    ++this.numHMMSingle;
                    break;
                }
                case INTERNAL: {
                    ++this.numHMMInternal;
                    break;
                }
            }
        } else {
            ++this.numOthers;
        }
    }

    public void dump() {
        System.out.println("TotalTokens: " + this.numTokens);
        System.out.println("      Words: " + this.numWords + this.pc(this.numWords));
        System.out.println("      Units: " + this.numUnits + this.pc(this.numUnits));
        System.out.println("      HMM-b: " + this.numHMMBegin + this.pc(this.numHMMBegin));
        System.out.println("      HMM-e: " + this.numHMMEnd + this.pc(this.numHMMEnd));
        System.out.println("      HMM-s: " + this.numHMMSingle + this.pc(this.numHMMSingle));
        System.out.println("      HMM-i: " + this.numHMMInternal + this.pc(this.numHMMInternal));
        System.out.println("     Others: " + this.numOthers + this.pc(this.numOthers));
    }

    private String pc(int n) {
        int n2 = 100 * n / this.numTokens;
        return " (" + n2 + "%)";
    }
}

