/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.denoise.Denoise;
import edu.cmu.sphinx.frontend.frequencywarp.MelFrequencyFilterBank;
import edu.cmu.sphinx.frontend.frequencywarp.MelFrequencyFilterBank2;
import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform;
import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform2;
import edu.cmu.sphinx.frontend.transform.KaldiDiscreteCosineTransform;
import edu.cmu.sphinx.frontend.transform.Lifter;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.KaldiLoader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AutoCepstrum
extends BaseDataProcessor {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    protected Loader loader;
    protected BaseDataProcessor filterBank;
    protected Denoise denoise;
    protected DiscreteCosineTransform dct;
    protected Lifter lifter;
    protected List<DataProcessor> selectedDataProcessors;

    public AutoCepstrum(Loader loader) throws IOException {
        this.initLogger();
        this.loader = loader;
        loader.load();
        this.initDataProcessors();
    }

    public AutoCepstrum() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.loader = (Loader)propertySheet.getComponent(PROP_LOADER);
        try {
            this.loader.load();
        }
        catch (IOException iOException) {
            throw new PropertyException(iOException);
        }
        this.initDataProcessors();
    }

    private void initDataProcessors() {
        try {
            Properties properties = this.loader.getProperties();
            this.selectedDataProcessors = new ArrayList<DataProcessor>();
            double d = Double.parseDouble(properties.getProperty("-lowerf"));
            double d2 = Double.parseDouble(properties.getProperty("-upperf"));
            int n = Integer.parseInt(properties.getProperty("-nfilt"));
            this.filterBank = this.loader instanceof KaldiLoader ? new MelFrequencyFilterBank2(d, d2, n) : new MelFrequencyFilterBank(d, d2, n);
            this.selectedDataProcessors.add(this.filterBank);
            if (properties.get("-remove_noise") == null || properties.get("-remove_noise").equals("yes")) {
                this.denoise = new Denoise(Denoise.class.getField("LAMBDA_POWER").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("LAMBDA_A").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("LAMBDA_B").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("LAMBDA_T").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("MU_T").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("MAX_GAIN").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("SMOOTH_WINDOW").getAnnotation(S4Integer.class).defaultValue());
                this.denoise.setPredecessor(this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1));
                this.selectedDataProcessors.add(this.denoise);
            }
            this.dct = properties.get("-transform") != null && properties.get("-transform").equals("dct") ? new DiscreteCosineTransform2(n, DiscreteCosineTransform.class.getField("PROP_CEPSTRUM_LENGTH").getAnnotation(S4Integer.class).defaultValue()) : (properties.get("-transform") != null && properties.get("-transform").equals("kaldi") ? new KaldiDiscreteCosineTransform(n, DiscreteCosineTransform.class.getField("PROP_CEPSTRUM_LENGTH").getAnnotation(S4Integer.class).defaultValue()) : new DiscreteCosineTransform(n, DiscreteCosineTransform.class.getField("PROP_CEPSTRUM_LENGTH").getAnnotation(S4Integer.class).defaultValue()));
            this.dct.setPredecessor(this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1));
            this.selectedDataProcessors.add(this.dct);
            if (properties.get("-lifter") != null) {
                this.lifter = new Lifter(Integer.parseInt((String)properties.get("-lifter")));
                this.lifter.setPredecessor(this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1));
                this.selectedDataProcessors.add(this.lifter);
            }
            this.logger.info("Cepstrum component auto-configured as follows: " + this.toString());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        for (DataProcessor dataProcessor : this.selectedDataProcessors) {
            dataProcessor.initialize();
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        DataProcessor dataProcessor = this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1);
        return dataProcessor.getData();
    }

    @Override
    public void setPredecessor(DataProcessor dataProcessor) {
        this.filterBank.setPredecessor(dataProcessor);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString()).append(" {");
        for (DataProcessor dataProcessor : this.selectedDataProcessors) {
            stringBuilder.append(dataProcessor).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.append('}').toString();
    }
}

