/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.LinkedList;

public class DataBlocker
extends BaseDataProcessor {
    @S4Double(defaultValue=10.0)
    public static final String PROP_BLOCK_SIZE_MS = "blockSizeMs";
    private double blockSizeMs;
    private int blockSizeSamples = Integer.MAX_VALUE;
    private int curFirstSamplePos;
    private int sampleRate = -1;
    private final LinkedList<DoubleData> inBuffer = new LinkedList();
    private int curInBufferSize;

    public DataBlocker() {
    }

    public DataBlocker(double d) {
        this.initLogger();
        this.blockSizeMs = d;
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.blockSizeMs = propertySheet.getDouble(PROP_BLOCK_SIZE_MS);
    }

    public double getBlockSizeMs() {
        return this.blockSizeMs;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Object object;
        while (this.curInBufferSize < this.blockSizeSamples || this.curInBufferSize == 0) {
            object = this.getPredecessor().getData();
            if (object instanceof DataStartSignal) {
                this.sampleRate = ((DataStartSignal)object).getSampleRate();
                this.blockSizeSamples = (int)Math.round((double)this.sampleRate * this.blockSizeMs / 1000.0);
                this.curInBufferSize = 0;
                this.curFirstSamplePos = 0;
                this.inBuffer.clear();
            }
            if (!(object instanceof DoubleData)) {
                return object;
            }
            DoubleData doubleData = (DoubleData)object;
            this.inBuffer.add(doubleData);
            this.curInBufferSize += doubleData.getValues().length;
        }
        object = new double[this.blockSizeSamples];
        int n = 0;
        long l = this.inBuffer.get(0).getFirstSampleNumber() + (long)this.curFirstSamplePos;
        while (!this.inBuffer.isEmpty()) {
            DoubleData doubleData = this.inBuffer.remove(0);
            double[] dArray = doubleData.getValues();
            int n2 = Math.min(this.blockSizeSamples - n, dArray.length - this.curFirstSamplePos);
            System.arraycopy(dArray, this.curFirstSamplePos, object, n, n2);
            if (n2 < dArray.length - this.curFirstSamplePos) {
                assert (this.inBuffer.isEmpty());
                this.curFirstSamplePos += n2;
                this.inBuffer.add(0, doubleData);
                break;
            }
            n += n2;
            this.curFirstSamplePos = 0;
        }
        this.curInBufferSize = this.inBuffer.isEmpty() ? 0 : this.inBuffer.get(0).getValues().length - this.curFirstSamplePos;
        return new DoubleData((double[])object, this.sampleRate, l);
    }
}

