/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.util.machlearn.OVector;

public class DoubleData
extends OVector
implements Data {
    private int sampleRate;
    private long firstSampleNumber;
    private long collectTime;

    public DoubleData(double[] dArray) {
        super(dArray);
    }

    public DoubleData(double[] dArray, int n, long l) {
        super(dArray);
        this.sampleRate = n;
        this.collectTime = l * 1000L / (long)n;
        this.firstSampleNumber = l;
    }

    public DoubleData(double[] dArray, int n, long l, long l2) {
        super(dArray);
        this.sampleRate = n;
        this.collectTime = l;
        this.firstSampleNumber = l2;
    }

    @Override
    public String toString() {
        return "DoubleData: " + this.sampleRate + "Hz, first sample #: " + this.firstSampleNumber + ", collect time: " + this.collectTime;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public long getFirstSampleNumber() {
        return this.firstSampleNumber;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public DoubleData clone() throws CloneNotSupportedException {
        try {
            DoubleData doubleData = (DoubleData)super.clone();
            doubleData.sampleRate = this.sampleRate;
            doubleData.collectTime = this.collectTime;
            doubleData.firstSampleNumber = this.firstSampleNumber;
            return doubleData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

