/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.MatrixUtils;

public class FloatData
implements Data,
Cloneable {
    private final float[] values;
    private final int sampleRate;
    private final long firstSampleNumber;
    private final long collectTime;

    public FloatData(float[] fArray, int n, long l) {
        this(fArray, n, l * 1000L / (long)n, l);
    }

    public FloatData(float[] fArray, int n, long l, long l2) {
        this.values = fArray;
        this.sampleRate = n;
        this.collectTime = l;
        this.firstSampleNumber = l2;
    }

    public float[] getValues() {
        return this.values;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public long getFirstSampleNumber() {
        return this.firstSampleNumber;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public FloatData clone() throws CloneNotSupportedException {
        try {
            FloatData floatData = (FloatData)super.clone();
            return floatData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static FloatData toFloatData(Data data) {
        FloatData floatData;
        if (data instanceof FloatData) {
            floatData = (FloatData)data;
        } else if (data instanceof DoubleData) {
            DoubleData doubleData = (DoubleData)data;
            floatData = new FloatData(MatrixUtils.double2float(doubleData.getValues()), doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        } else {
            throw new IllegalArgumentException("data type '" + data.getClass() + "' is not supported");
        }
        return floatData;
    }
}

