/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.SignalListener;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FrontEnd
extends BaseDataProcessor {
    @S4ComponentList(type=DataProcessor.class)
    public static final String PROP_PIPELINE = "pipeline";
    private List<DataProcessor> frontEndList;
    private Timer timer;
    private DataProcessor first;
    private DataProcessor last;
    private final List<SignalListener> signalListeners = new ArrayList<SignalListener>();

    public FrontEnd(List<DataProcessor> list) {
        this.initLogger();
        this.frontEndList = list;
        this.init();
    }

    public FrontEnd() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.frontEndList = propertySheet.getComponentList(PROP_PIPELINE, DataProcessor.class);
        this.init();
    }

    private void init() {
        this.timer = TimerPool.getTimer(this, "Frontend");
        this.last = null;
        for (DataProcessor dataProcessor : this.frontEndList) {
            assert (dataProcessor != null);
            if (this.last != null) {
                dataProcessor.setPredecessor(this.last);
            }
            if (this.first == null) {
                this.first = dataProcessor;
            }
            this.last = dataProcessor;
        }
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        for (DataProcessor dataProcessor : this.frontEndList) {
            dataProcessor.initialize();
        }
    }

    public void setDataSource(DataProcessor dataProcessor) {
        this.first.setPredecessor(dataProcessor);
    }

    public List<DataProcessor> getElements() {
        return this.frontEndList;
    }

    @Override
    public Data getData() throws DataProcessingException {
        this.timer.start();
        Data data = this.last.getData();
        if (data instanceof Signal) {
            this.fireSignalListeners((Signal)data);
        }
        this.timer.stop();
        return data;
    }

    @Override
    public void setPredecessor(DataProcessor dataProcessor) {
        this.setDataSource(dataProcessor);
    }

    public void addSignalListener(SignalListener signalListener) {
        this.signalListeners.add(signalListener);
    }

    public void removeSignalListener(SignalListener signalListener) {
        this.signalListeners.remove(signalListener);
    }

    protected void fireSignalListeners(Signal signal) {
        for (SignalListener signalListener : new ArrayList<SignalListener>(this.signalListeners)) {
            signalListener.signalOccurred(signal);
        }
    }

    public DataProcessor getLastDataProcessor() {
        return this.last;
    }

    @Override
    public String toString() {
        Object object;
        if (this.last == null) {
            return super.toString() + " {}";
        }
        LinkedList<DataProcessor> linkedList = new LinkedList<DataProcessor>();
        for (object = this.last; object != null; object = object.getPredecessor()) {
            linkedList.addFirst((DataProcessor)object);
        }
        object = new StringBuilder(super.toString()).append(" {");
        for (DataProcessor dataProcessor : linkedList) {
            ((StringBuilder)object).append(dataProcessor).append(", ");
        }
        ((StringBuilder)object).setLength(((StringBuilder)object).length() - 2);
        return ((StringBuilder)object).append('}').toString();
    }
}

