/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;

public class GainControlProcessor
extends BaseDataProcessor {
    @S4Double(defaultValue=1.0)
    public static final String GAIN_FACTOR = "gainFactor";
    private double gainFactor;

    public GainControlProcessor(double d) {
        this.initLogger();
        this.gainFactor = d;
    }

    public GainControlProcessor() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.gainFactor = propertySheet.getDouble(GAIN_FACTOR);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        block5: {
            block4: {
                data = this.getPredecessor().getData();
                if (!(data instanceof FloatData)) break block4;
                float[] fArray = ((FloatData)data).getValues();
                if (this.gainFactor == 1.0) break block5;
                int n = 0;
                while (n < fArray.length) {
                    int n2 = n++;
                    fArray[n2] = (float)((double)fArray[n2] * this.gainFactor);
                }
                break block5;
            }
            if (data instanceof DoubleData) {
                double[] dArray = ((DoubleData)data).getValues();
                if (this.gainFactor != 1.0) {
                    int n = 0;
                    while (n < dArray.length) {
                        int n3 = n++;
                        dArray[n3] = dArray[n3] * this.gainFactor;
                    }
                }
            }
        }
        return data;
    }

    public double getGainFactor() {
        return this.gainFactor;
    }

    public void setGainFactor(double d) {
        this.gainFactor = d;
    }
}

