/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.databranch;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.databranch.DataListener;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DataBufferProcessor
extends BaseDataProcessor
implements DataListener {
    private final List<Data> featureBuffer = new LinkedList<Data>();
    @S4Boolean(defaultValue=false)
    public static final String PROP_WAIT_IF_EMPTY = "waitIfEmpty";
    private boolean waitIfEmpty;
    @S4Integer(defaultValue=10)
    public static final String PROP_WAIT_TIME_MS = "waitTimeMs";
    private long waitTime;
    @S4Integer(defaultValue=50000)
    public static final String PROP_BUFFER_SIZE = "maxBufferSize";
    private int maxBufferSize;
    @S4ComponentList(type=Configurable.class, beTolerant=true)
    public static final String DATA_LISTENERS = "dataListeners";
    private List<DataListener> dataListeners = new ArrayList<DataListener>();

    public DataBufferProcessor(int n, boolean bl, int n2, List<? extends Configurable> list) {
        this.initLogger();
        this.maxBufferSize = n;
        this.waitIfEmpty = bl;
        if (bl) {
            this.waitTime = n2;
        }
        for (Configurable configurable : list) {
            assert (configurable instanceof DataListener);
            this.addDataListener((DataListener)((Object)configurable));
        }
    }

    public DataBufferProcessor() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.maxBufferSize = propertySheet.getInt(PROP_BUFFER_SIZE);
        this.waitIfEmpty = propertySheet.getBoolean(PROP_WAIT_IF_EMPTY);
        if (this.waitIfEmpty) {
            this.waitTime = propertySheet.getInt(PROP_WAIT_TIME_MS);
        }
        this.dataListeners = propertySheet.getComponentList(DATA_LISTENERS, DataListener.class);
    }

    @Override
    public void processDataFrame(Data data) {
        this.featureBuffer.add(data);
        for (DataListener dataListener : this.dataListeners) {
            dataListener.processDataFrame(data);
        }
        while (this.featureBuffer.size() > this.maxBufferSize) {
            this.featureBuffer.remove(0);
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        while (this.waitIfEmpty && this.featureBuffer.isEmpty()) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (!this.featureBuffer.isEmpty()) {
            data = this.featureBuffer.remove(0);
        } else assert (!this.waitIfEmpty);
        return data;
    }

    public int getBufferSize() {
        return this.featureBuffer.size();
    }

    public void clearBuffer() {
        this.featureBuffer.clear();
    }

    public List<Data> getBuffer() {
        return Collections.unmodifiableList(this.featureBuffer);
    }

    public void addDataListener(DataListener dataListener) {
        if (dataListener == null) {
            return;
        }
        this.dataListeners.add(dataListener);
    }

    public void removeDataListener(DataListener dataListener) {
        if (dataListener == null) {
            return;
        }
        this.dataListeners.remove(dataListener);
    }
}

