/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.denoise;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;

public class Denoise
extends BaseDataProcessor {
    double[] power;
    double[] noise;
    double[] floor;
    double[] peak;
    @S4Double(defaultValue=0.7)
    public static final String LAMBDA_POWER = "lambdaPower";
    double lambdaPower;
    @S4Double(defaultValue=0.995)
    public static final String LAMBDA_A = "lambdaA";
    double lambdaA;
    @S4Double(defaultValue=0.5)
    public static final String LAMBDA_B = "lambdaB";
    double lambdaB;
    @S4Double(defaultValue=0.85)
    public static final String LAMBDA_T = "lambdaT";
    double lambdaT;
    @S4Double(defaultValue=0.2)
    public static final String MU_T = "muT";
    double muT;
    @S4Double(defaultValue=20.0)
    public static final String MAX_GAIN = "maxGain";
    double maxGain;
    @S4Integer(defaultValue=4)
    public static final String SMOOTH_WINDOW = "smoothWindow";
    int smoothWindow;
    static final double EPS = 1.0E-10;

    public Denoise(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.lambdaPower = d;
        this.lambdaA = d2;
        this.lambdaB = d3;
        this.lambdaT = d4;
        this.muT = d5;
        this.maxGain = d6;
        this.smoothWindow = n;
    }

    public Denoise() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.lambdaPower = propertySheet.getDouble(LAMBDA_POWER);
        this.lambdaA = propertySheet.getDouble(LAMBDA_A);
        this.lambdaB = propertySheet.getDouble(LAMBDA_B);
        this.lambdaT = propertySheet.getDouble(LAMBDA_T);
        this.muT = propertySheet.getDouble(MU_T);
        this.maxGain = propertySheet.getDouble(MAX_GAIN);
        this.smoothWindow = propertySheet.getInt(SMOOTH_WINDOW);
    }

    @Override
    public Data getData() throws DataProcessingException {
        int n;
        Data data = this.getPredecessor().getData();
        if (data instanceof DataStartSignal) {
            this.power = null;
            this.noise = null;
            this.floor = null;
            this.peak = null;
            return data;
        }
        if (!(data instanceof DoubleData)) {
            return data;
        }
        DoubleData doubleData = (DoubleData)data;
        double[] dArray = doubleData.getValues();
        int n2 = dArray.length;
        if (this.power == null) {
            this.initStatistics(dArray, n2);
        }
        this.updatePower(dArray);
        this.estimateEnvelope(this.power, this.noise);
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = Math.max(this.power[n] - this.noise[n], 0.0);
        }
        this.estimateEnvelope(dArray2, this.floor);
        this.tempMasking(dArray2);
        this.powerBoosting(dArray2);
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = dArray2[n] / (this.power[n] + 1.0E-10);
            dArray3[n] = Math.min(Math.max(dArray3[n], 1.0 / this.maxGain), this.maxGain);
        }
        double[] dArray4 = this.smooth(dArray3);
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] * dArray4[n];
        }
        return data;
    }

    private double[] smooth(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            int n = Math.max(i - this.smoothWindow, 0);
            int n2 = Math.min(i + this.smoothWindow + 1, dArray.length);
            double d = 0.0;
            for (int j = n; j < n2; ++j) {
                d += dArray[j];
            }
            dArray2[i] = d / (double)(n2 - n);
        }
        return dArray2;
    }

    private void powerBoosting(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < this.floor[i])) continue;
            dArray[i] = this.floor[i];
        }
    }

    private void tempMasking(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            int n = i;
            this.peak[n] = this.peak[n] * this.lambdaT;
            if (dArray[i] < this.lambdaT * this.peak[i]) {
                dArray[i] = this.peak[i] * this.muT;
            }
            if (!(d > this.peak[i])) continue;
            this.peak[i] = d;
        }
    }

    private void updatePower(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.power[i] = this.lambdaPower * this.power[i] + (1.0 - this.lambdaPower) * dArray[i];
        }
    }

    private void estimateEnvelope(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] > dArray2[i] ? this.lambdaA * dArray2[i] + (1.0 - this.lambdaA) * dArray[i] : this.lambdaB * dArray2[i] + (1.0 - this.lambdaB) * dArray[i];
        }
    }

    private void initStatistics(double[] dArray, int n) {
        this.power = Arrays.copyOf(dArray, n);
        this.noise = Arrays.copyOf(dArray, n);
        this.floor = new double[n];
        this.peak = new double[n];
        for (int i = 0; i < n; ++i) {
            this.floor[i] = dArray[i] / this.maxGain;
        }
    }
}

