/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.AbstractVoiceActivityDetector;
import edu.cmu.sphinx.frontend.endpoint.SpeechClassifiedData;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.logging.Level;

public class SpeechClassifier
extends AbstractVoiceActivityDetector {
    @S4Integer(defaultValue=10)
    public static final String PROP_FRAME_LENGTH_MS = "frameLengthInMs";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MIN_SIGNAL = "minSignal";
    @S4Double(defaultValue=10.0)
    public static final String PROP_THRESHOLD = "threshold";
    @S4Double(defaultValue=0.003)
    public static final String PROP_ADJUSTMENT = "adjustment";
    protected final double averageNumber = 1.0;
    protected double adjustment;
    protected double level;
    protected double background;
    protected double minSignal;
    protected double threshold;
    protected float frameLengthSec;
    protected boolean isSpeech;
    protected long speechFrames;
    protected long backgroundFrames;
    protected double totalBackgroundLevel;
    protected double totalSpeechLevel;

    public SpeechClassifier(int n, double d, double d2, double d3) {
        this.initLogger();
        this.frameLengthSec = (float)n / 1000.0f;
        this.adjustment = d;
        this.threshold = d2;
        this.minSignal = d3;
        this.initialize();
    }

    public SpeechClassifier() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        int n = propertySheet.getInt(PROP_FRAME_LENGTH_MS);
        this.frameLengthSec = (float)n / 1000.0f;
        this.adjustment = propertySheet.getDouble(PROP_ADJUSTMENT);
        this.threshold = propertySheet.getDouble(PROP_THRESHOLD);
        this.minSignal = propertySheet.getDouble(PROP_MIN_SIGNAL);
        this.logger = propertySheet.getLogger();
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reset();
    }

    protected void reset() {
        this.level = 0.0;
        this.background = 300.0;
        this.resetStats();
    }

    public static double logRootMeanSquare(double[] dArray) {
        assert (dArray.length > 0);
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2 * d2;
        }
        double d3 = Math.sqrt(d / (double)dArray.length);
        d3 = Math.max(d3, 1.0);
        return LogMath.log10((float)d3) * 20.0f;
    }

    protected SpeechClassifiedData classify(DoubleData doubleData) {
        double d = SpeechClassifier.logRootMeanSquare(doubleData.getValues());
        this.isSpeech = false;
        if (d >= this.minSignal) {
            this.level = (this.level * 1.0 + d) / 2.0;
            this.background = d < this.background ? d : (this.background += (d - this.background) * this.adjustment);
            if (this.level < this.background) {
                this.level = this.background;
            }
            this.isSpeech = this.level - this.background > this.threshold;
        }
        SpeechClassifiedData speechClassifiedData = new SpeechClassifiedData(doubleData, this.isSpeech);
        if (this.logger.isLoggable(Level.FINEST)) {
            String string = "";
            if (speechClassifiedData.isSpeech()) {
                string = "*";
            }
            this.logger.finest("Bkg: " + this.background + ", level: " + this.level + ", current: " + d + ' ' + string);
        }
        this.collectStats(this.isSpeech);
        return speechClassifiedData;
    }

    private void resetStats() {
        this.backgroundFrames = 1L;
        this.speechFrames = 1L;
        this.totalSpeechLevel = 0.0;
        this.totalBackgroundLevel = 0.0;
    }

    private void collectStats(boolean bl) {
        if (bl) {
            this.totalSpeechLevel += this.level;
            ++this.speechFrames;
        } else {
            this.totalBackgroundLevel += this.background;
            ++this.backgroundFrames;
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data instanceof DataStartSignal) {
            this.reset();
        }
        if (data instanceof DoubleData) {
            DoubleData doubleData = (DoubleData)data;
            data = this.classify(doubleData);
        }
        return data;
    }

    @Override
    public boolean isSpeech() {
        return this.isSpeech;
    }

    public double getSNR() {
        double d = this.totalSpeechLevel / (double)this.speechFrames - this.totalBackgroundLevel / (double)this.backgroundFrames;
        this.logger.fine("Background " + this.totalBackgroundLevel / (double)this.backgroundFrames);
        this.logger.fine("Speech " + this.totalSpeechLevel / (double)this.speechFrames);
        this.logger.fine("SNR is " + d);
        return d;
    }

    public boolean getNoisy() {
        return this.getSNR() < 20.0;
    }
}

