/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechClassifiedData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.LinkedList;

public class SpeechMarker
extends BaseDataProcessor {
    @S4Integer(defaultValue=200)
    public static final String PROP_START_SPEECH = "startSpeech";
    private int startSpeechTime;
    @S4Integer(defaultValue=200)
    public static final String PROP_END_SILENCE = "endSilence";
    private int endSilenceTime;
    @S4Integer(defaultValue=50)
    public static final String PROP_SPEECH_LEADER = "speechLeader";
    private int speechLeader;
    private LinkedList<Data> inputQueue;
    private LinkedList<Data> outputQueue;
    private boolean inSpeech;
    private int speechCount;
    private int silenceCount;
    private int startSpeechFrames;
    private int endSilenceFrames;
    private int speechLeaderFrames;

    public SpeechMarker(int n, int n2, int n3) {
        this.initLogger();
        this.startSpeechTime = n;
        this.speechLeader = n3;
        this.endSilenceTime = n2;
    }

    public SpeechMarker() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.startSpeechTime = propertySheet.getInt(PROP_START_SPEECH);
        this.endSilenceTime = propertySheet.getInt(PROP_END_SILENCE);
        this.speechLeader = propertySheet.getInt(PROP_SPEECH_LEADER);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reset();
    }

    private void reset() {
        this.inSpeech = false;
        this.speechCount = 0;
        this.silenceCount = 0;
        this.startSpeechFrames = this.startSpeechTime / 10;
        this.endSilenceFrames = this.endSilenceTime / 10;
        this.speechLeaderFrames = this.speechLeader / 10;
        this.inputQueue = new LinkedList();
        this.outputQueue = new LinkedList();
    }

    @Override
    public Data getData() throws DataProcessingException {
        SpeechClassifiedData speechClassifiedData;
        Data data;
        while (this.outputQueue.isEmpty() && (data = this.getPredecessor().getData()) != null) {
            if (data instanceof DataStartSignal) {
                this.reset();
                this.outputQueue.add(data);
                break;
            }
            if (data instanceof DataEndSignal) {
                if (this.inSpeech) {
                    this.outputQueue.add(new SpeechEndSignal());
                }
                this.outputQueue.add(data);
                break;
            }
            if (!(data instanceof SpeechClassifiedData)) continue;
            speechClassifiedData = (SpeechClassifiedData)data;
            if (speechClassifiedData.isSpeech()) {
                ++this.speechCount;
                this.silenceCount = 0;
            } else {
                this.speechCount = 0;
                ++this.silenceCount;
            }
            if (this.inSpeech) {
                this.outputQueue.add(data);
            } else {
                this.inputQueue.add(data);
                if (this.inputQueue.size() > this.startSpeechFrames + this.speechLeaderFrames) {
                    this.inputQueue.remove(0);
                }
            }
            if (!this.inSpeech && this.speechCount == this.startSpeechFrames) {
                this.inSpeech = true;
                this.outputQueue.add(new SpeechStartSignal(speechClassifiedData.getCollectTime() - (long)this.speechLeader - (long)this.startSpeechFrames));
                this.outputQueue.addAll(this.inputQueue.subList(Math.max(0, this.inputQueue.size() - this.startSpeechFrames - this.speechLeaderFrames), this.inputQueue.size()));
                this.inputQueue.clear();
            }
            if (!this.inSpeech || this.silenceCount != this.endSilenceFrames) continue;
            this.inSpeech = false;
            this.outputQueue.add(new SpeechEndSignal(speechClassifiedData.getCollectTime()));
        }
        if (!this.outputQueue.isEmpty()) {
            data = this.outputQueue.remove(0);
            if (data instanceof SpeechClassifiedData) {
                speechClassifiedData = (SpeechClassifiedData)data;
                data = speechClassifiedData.getDoubleData();
            }
            return data;
        }
        return null;
    }

    public boolean inSpeech() {
        return this.inSpeech;
    }
}

