/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;
import java.util.LinkedList;

public abstract class AbstractFeatureExtractor
extends BaseDataProcessor {
    @S4Integer(defaultValue=3)
    public static final String PROP_FEATURE_WINDOW = "windowSize";
    private int bufferPosition;
    private Signal pendingSignal;
    private LinkedList<Data> outputQueue;
    protected int cepstraBufferEdge;
    protected int window;
    protected int currentPosition;
    protected int cepstraBufferSize;
    protected DoubleData[] cepstraBuffer;

    public AbstractFeatureExtractor(int n) {
        this.initLogger();
        this.window = n;
    }

    public AbstractFeatureExtractor() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.window = propertySheet.getInt(PROP_FEATURE_WINDOW);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.cepstraBufferSize = 256;
        this.cepstraBuffer = new DoubleData[this.cepstraBufferSize];
        this.cepstraBufferEdge = this.cepstraBufferSize - (this.window * 2 + 2);
        this.outputQueue = new LinkedList();
        this.reset();
    }

    private void reset() {
        this.bufferPosition = 0;
        this.currentPosition = 0;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        if (this.outputQueue.isEmpty() && (data = this.getNextData()) != null) {
            if (data instanceof DoubleData) {
                this.addCepstrum((DoubleData)data);
                this.computeFeatures(1);
            } else if (data instanceof DataStartSignal) {
                this.pendingSignal = null;
                this.outputQueue.add(data);
                Data data2 = this.getNextData();
                int n = this.processFirstCepstrum(data2);
                this.computeFeatures(n);
                if (this.pendingSignal != null) {
                    this.outputQueue.add(this.pendingSignal);
                }
            } else if (data instanceof SpeechEndSignal) {
                int n = this.replicateLastCepstrum();
                this.computeFeatures(n);
                this.outputQueue.add(data);
            } else if (data instanceof DataEndSignal) {
                this.outputQueue.add(data);
            }
        }
        return this.outputQueue.isEmpty() ? null : this.outputQueue.removeFirst();
    }

    private Data getNextData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        while (!(data == null || data instanceof DoubleData || data instanceof DataEndSignal || data instanceof DataStartSignal || data instanceof SpeechEndSignal)) {
            this.outputQueue.add(data);
            data = this.getPredecessor().getData();
        }
        return data;
    }

    private int processFirstCepstrum(Data data) throws DataProcessingException {
        if (data instanceof DataEndSignal) {
            this.outputQueue.add(data);
            return 0;
        }
        if (data instanceof DataStartSignal) {
            throw new Error("Too many UTTERANCE_START");
        }
        Arrays.fill(this.cepstraBuffer, 0, this.window + 1, data);
        this.bufferPosition = this.window + 1;
        this.bufferPosition %= this.cepstraBufferSize;
        this.currentPosition = this.window;
        this.currentPosition %= this.cepstraBufferSize;
        int n = 1;
        this.pendingSignal = null;
        for (int i = 0; i < this.window; ++i) {
            Data data2 = this.getNextData();
            if (data2 == null) continue;
            if (data2 instanceof DoubleData) {
                this.addCepstrum((DoubleData)data2);
                continue;
            }
            if (data2 instanceof DataEndSignal || data2 instanceof SpeechEndSignal) {
                this.pendingSignal = (Signal)data2;
                this.replicateLastCepstrum();
                n += i;
                break;
            }
            if (!(data2 instanceof DataStartSignal)) continue;
            throw new Error("Too many UTTERANCE_START");
        }
        return n;
    }

    private void addCepstrum(DoubleData doubleData) {
        this.cepstraBuffer[this.bufferPosition++] = doubleData;
        this.bufferPosition %= this.cepstraBufferSize;
    }

    private int replicateLastCepstrum() {
        DoubleData doubleData;
        if (this.bufferPosition > 0) {
            doubleData = this.cepstraBuffer[this.bufferPosition - 1];
        } else if (this.bufferPosition == 0) {
            doubleData = this.cepstraBuffer[this.cepstraBuffer.length - 1];
        } else {
            throw new Error("BufferPosition < 0");
        }
        for (int i = 0; i < this.window; ++i) {
            this.addCepstrum(doubleData);
        }
        return this.window;
    }

    private void computeFeatures(int n) {
        if (n == 1) {
            this.computeFeature();
        } else {
            for (int i = 0; i < n; ++i) {
                this.computeFeature();
            }
        }
    }

    private void computeFeature() {
        Data data = this.computeNextFeature();
        this.outputQueue.add(data);
    }

    protected abstract Data computeNextFeature();
}

