/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.LinkedList;
import java.util.List;

public class BatchAGC
extends BaseDataProcessor {
    private List<Data> cepstraList;
    private double agc;

    public BatchAGC() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.cepstraList = new LinkedList<Data>();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        if (!this.cepstraList.isEmpty()) {
            data = this.cepstraList.remove(0);
        } else {
            this.agc = 0.0;
            this.cepstraList.clear();
            if (this.readUtterance() > 0) {
                this.normalizeList();
                data = this.cepstraList.remove(0);
            }
        }
        return data;
    }

    private int readUtterance() throws DataProcessingException {
        Data data = null;
        int n = 0;
        while ((data = this.getPredecessor().getData()) != null) {
            if (data instanceof DataEndSignal || data instanceof SpeechEndSignal) {
                this.cepstraList.add(data);
                break;
            }
            if (data instanceof DoubleData) {
                this.cepstraList.add(data);
                double d = ((DoubleData)data).getValues()[0];
                if (this.agc < d) {
                    this.agc = d;
                }
            } else {
                this.cepstraList.add(data);
            }
            ++n;
        }
        return n;
    }

    private void normalizeList() {
        for (Data data : this.cepstraList) {
            if (!(data instanceof DoubleData)) continue;
            double[] dArray = ((DoubleData)data).getValues();
            dArray[0] = dArray[0] - this.agc;
        }
    }
}

