/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class BatchCMN
extends BaseDataProcessor {
    private double[] sums;
    private List<Data> cepstraList;
    private int numberDataCepstra;
    private DecimalFormat formatter = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.US));

    public BatchCMN() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sums = null;
        this.cepstraList = new LinkedList<Data>();
    }

    private void reset() {
        this.sums = null;
        this.cepstraList.clear();
        this.numberDataCepstra = 0;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        if (!this.cepstraList.isEmpty()) {
            data = this.cepstraList.remove(0);
        } else {
            this.reset();
            if (this.readUtterance() > 0) {
                this.normalizeList();
                data = this.cepstraList.remove(0);
            }
        }
        return data;
    }

    private int readUtterance() throws DataProcessingException {
        Data data = null;
        do {
            if ((data = this.getPredecessor().getData()) == null) continue;
            if (data instanceof DoubleData) {
                double[] dArray = ((DoubleData)data).getValues();
                if (this.sums == null) {
                    this.sums = new double[dArray.length];
                } else if (this.sums.length != dArray.length) {
                    throw new Error("Inconsistent cepstrum lengths: sums: " + this.sums.length + ", cepstrum: " + dArray.length);
                }
                if (dArray[0] >= 0.0) {
                    for (int i = 0; i < dArray.length; ++i) {
                        int n = i;
                        this.sums[n] = this.sums[n] + dArray[i];
                    }
                    ++this.numberDataCepstra;
                }
                this.cepstraList.add(data);
                continue;
            }
            if (data instanceof DataEndSignal || data instanceof SpeechEndSignal) {
                this.cepstraList.add(data);
                break;
            }
            this.cepstraList.add(data);
        } while (data != null);
        return this.numberDataCepstra;
    }

    private void normalizeList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.sums.length; ++i) {
            int n = i;
            this.sums[n] = this.sums[n] / (double)this.numberDataCepstra;
            stringBuilder.append(this.formatter.format(this.sums[i]));
            stringBuilder.append(' ');
        }
        this.logger.info(stringBuilder.toString());
        for (Data data : this.cepstraList) {
            if (!(data instanceof DoubleData)) continue;
            double[] dArray = ((DoubleData)data).getValues();
            for (int i = 0; i < dArray.length; ++i) {
                int n = i;
                dArray[n] = dArray[n] - this.sums[i];
            }
        }
    }
}

