/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.LinkedList;
import java.util.List;

public class BatchVarNorm
extends BaseDataProcessor {
    private double[] variances;
    private List<Data> cepstraList;
    private int numberDataCepstra;

    public BatchVarNorm() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.variances = null;
        this.cepstraList = new LinkedList<Data>();
    }

    private void reset() {
        this.variances = null;
        this.cepstraList.clear();
        this.numberDataCepstra = 0;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        if (!this.cepstraList.isEmpty()) {
            data = this.cepstraList.remove(0);
        } else {
            this.reset();
            if (this.readUtterance() > 0) {
                this.normalizeList();
                data = this.cepstraList.remove(0);
            }
        }
        return data;
    }

    private int readUtterance() throws DataProcessingException {
        Data data = null;
        do {
            if ((data = this.getPredecessor().getData()) == null) continue;
            if (data instanceof DoubleData) {
                ++this.numberDataCepstra;
                double[] dArray = ((DoubleData)data).getValues();
                if (this.variances == null) {
                    this.variances = new double[dArray.length];
                } else if (this.variances.length != dArray.length) {
                    throw new Error("Inconsistent cepstrum lengths: sums: " + this.variances.length + ", cepstrum: " + dArray.length);
                }
                for (int i = 0; i < dArray.length; ++i) {
                    int n = i;
                    this.variances[n] = this.variances[n] + dArray[i] * dArray[i];
                }
                this.cepstraList.add(data);
                continue;
            }
            if (data instanceof DataEndSignal || data instanceof SpeechEndSignal) {
                this.cepstraList.add(data);
                break;
            }
            this.cepstraList.add(data);
        } while (data != null);
        return this.numberDataCepstra;
    }

    private void normalizeList() {
        for (int i = 0; i < this.variances.length; ++i) {
            this.variances[i] = Math.sqrt((double)this.numberDataCepstra / this.variances[i]);
        }
        for (Data data : this.cepstraList) {
            if (!(data instanceof DoubleData)) continue;
            double[] dArray = ((DoubleData)data).getValues();
            for (int i = 0; i < dArray.length; ++i) {
                int n = i;
                dArray[n] = dArray[n] * this.variances[i];
            }
        }
    }
}

