/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;

public class FeatureTransform
extends BaseDataProcessor {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    float[][] transform;
    protected Loader loader;
    int rows;
    int values;

    public FeatureTransform(Loader loader) {
        this.initLogger();
        this.init(loader);
    }

    public FeatureTransform() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.init((Loader)propertySheet.getComponent(PROP_LOADER));
    }

    private void init(Loader loader) {
        this.loader = loader;
        try {
            loader.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.transform = loader.getTransformMatrix();
    }

    @Override
    public Data getData() throws DataProcessingException {
        int n;
        Data data = this.getPredecessor().getData();
        if (null == this.transform || null == data || !(data instanceof FloatData)) {
            return data;
        }
        FloatData floatData = (FloatData)data;
        float[] fArray = floatData.getValues();
        if (fArray.length > this.transform[0].length + 1) {
            throw new IllegalArgumentException("dimenstion mismatch");
        }
        float[] fArray2 = new float[this.transform.length];
        for (n = 0; n < this.transform.length; ++n) {
            for (int i = 0; i < fArray.length; ++i) {
                int n2 = n;
                fArray2[n2] = fArray2[n2] + this.transform[n][i] * fArray[i];
            }
        }
        if (fArray.length > this.transform[0].length) {
            for (n = 0; n < this.transform.length; ++n) {
                int n3 = n;
                fArray2[n3] = fArray2[n3] + this.transform[n][fArray.length];
            }
        }
        return new FloatData(fArray2, floatData.getSampleRate(), floatData.getFirstSampleNumber());
    }
}

