/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;

public class FrameDropper
extends BaseDataProcessor {
    @S4Integer(defaultValue=-1)
    public static final String PROP_DROP_EVERY_NTH_FRAME = "dropEveryNthFrame";
    @S4Boolean(defaultValue=false)
    public static final String PROP_REPLACE_NTH_WITH_PREVIOUS = "replaceNthWithPrevious";
    private Data lastFeature;
    private boolean replaceNthWithPrevious;
    private int dropEveryNthFrame;
    private int id;

    public FrameDropper(int n, boolean bl) {
        this.initLogger();
        this.initVars(n, bl);
    }

    public FrameDropper() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.initVars(propertySheet.getInt(PROP_DROP_EVERY_NTH_FRAME), propertySheet.getBoolean(PROP_REPLACE_NTH_WITH_PREVIOUS));
    }

    protected void initVars(int n, boolean bl) {
        this.dropEveryNthFrame = n;
        if (n <= 1) {
            throw new IllegalArgumentException("dropEveryNthFramemust be greater than one");
        }
        this.replaceNthWithPrevious = bl;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.id = -1;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.readData();
        if (data != null) {
            if (!(data instanceof Signal) && this.id % this.dropEveryNthFrame == this.dropEveryNthFrame - 1) {
                if (this.replaceNthWithPrevious) {
                    if (data instanceof FloatData) {
                        FloatData floatData = (FloatData)this.lastFeature;
                        data = new FloatData(floatData.getValues(), floatData.getSampleRate(), floatData.getFirstSampleNumber());
                    } else {
                        DoubleData doubleData = (DoubleData)this.lastFeature;
                        data = new DoubleData(doubleData.getValues(), doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
                    }
                } else {
                    data = this.readData();
                }
            }
            if (data != null) {
                if (data instanceof DataEndSignal) {
                    this.id = -1;
                }
                this.lastFeature = data instanceof FloatData ? data : null;
            } else {
                this.lastFeature = null;
            }
        }
        return data;
    }

    private Data readData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null) {
            ++this.id;
        }
        return data;
    }
}

