/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class LiveCMN
extends BaseDataProcessor {
    private DecimalFormat formatter = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.US));
    @S4Integer(defaultValue=200)
    public static final String PROP_INITIAL_CMN_WINDOW = "initialCmnWindow";
    private int initialCmnWindow;
    @S4Integer(defaultValue=300)
    public static final String PROP_CMN_WINDOW = "cmnWindow";
    private int cmnWindow;
    @S4Integer(defaultValue=400)
    public static final String PROP_CMN_SHIFT_WINDOW = "shiftWindow";
    private int cmnShiftWindow;
    private double[] currentMean;
    private double[] sum;
    private int numberFrame;
    List<Data> initialList;

    public LiveCMN(double d, int n, int n2, int n3) {
        this.initLogger();
        this.cmnWindow = n;
        this.cmnShiftWindow = n2;
        this.initialCmnWindow = n3;
    }

    public LiveCMN() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.cmnWindow = propertySheet.getInt(PROP_CMN_WINDOW);
        this.cmnShiftWindow = propertySheet.getInt(PROP_CMN_SHIFT_WINDOW);
        this.initialCmnWindow = propertySheet.getInt(PROP_INITIAL_CMN_WINDOW);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private void initMeansSums() {
        int n = -1;
        for (Data data : this.initialList) {
            if (!(data instanceof DoubleData)) continue;
            double[] dArray = ((DoubleData)data).getValues();
            if (n < 0) {
                n = dArray.length;
                this.sum = new double[n];
                this.numberFrame = 0;
            }
            if (!(dArray[0] >= 0.0)) continue;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.sum[n2] = this.sum[n2] + dArray[i];
            }
            ++this.numberFrame;
        }
        if (n < 0) {
            return;
        }
        this.currentMean = new double[n];
        for (int i = 0; i < n; ++i) {
            this.currentMean[i] = this.sum[i] / (double)this.numberFrame;
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        if (this.initialList == null) {
            this.initialList = new LinkedList<Data>();
            while (this.initialList.size() < this.initialCmnWindow) {
                Data data2 = this.getPredecessor().getData();
                this.initialList.add(data2);
                if (!(data2 instanceof SpeechEndSignal) && !(data2 instanceof DataEndSignal)) continue;
            }
            this.initMeansSums();
            data = this.initialList.remove(0);
        } else {
            data = !this.initialList.isEmpty() ? this.initialList.remove(0) : this.getPredecessor().getData();
        }
        this.normalize(data);
        return data;
    }

    private void normalize(Data data) {
        int n;
        if (!(data instanceof DoubleData)) {
            return;
        }
        double[] dArray = ((DoubleData)data).getValues();
        if (dArray.length != this.sum.length) {
            throw new Error("Data length (" + dArray.length + ") not equal sum array length (" + this.sum.length + ')');
        }
        if (dArray[0] >= 0.0) {
            for (n = 0; n < dArray.length; ++n) {
                int n2 = n;
                this.sum[n2] = this.sum[n2] + dArray[n];
            }
            ++this.numberFrame;
        }
        for (n = 0; n < dArray.length; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] - this.currentMean[n];
        }
        if (this.numberFrame > this.cmnShiftWindow) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.currentMean.length; ++i) {
                stringBuilder.append(this.formatter.format(this.currentMean[i]));
                stringBuilder.append(' ');
            }
            this.logger.info(stringBuilder.toString());
            this.updateMeanSumBuffers();
        }
    }

    private void updateMeanSumBuffers() {
        double d = 1.0 / (double)this.numberFrame;
        System.arraycopy(this.sum, 0, this.currentMean, 0, this.sum.length);
        LiveCMN.multiplyArray(this.currentMean, d);
        if (this.numberFrame >= this.cmnShiftWindow) {
            LiveCMN.multiplyArray(this.sum, d * (double)this.cmnWindow);
            this.numberFrame = this.cmnWindow;
        }
    }

    private static void multiplyArray(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }
}

