/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.filter;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.Random;

public class Dither
extends BaseDataProcessor {
    @S4Double(defaultValue=2.0)
    public static final String PROP_MAX_DITHER = "maxDither";
    private double ditherMax;
    @S4Double(defaultValue=1.7976931348623157E308)
    public static final String PROP_MAX_VAL = "upperValueBound";
    private double maxValue;
    @S4Double(defaultValue=-1.7976931348623157E308)
    public static final String PROP_MIN_VAL = "lowerValueBound";
    private double minValue;
    @S4Boolean(defaultValue=false)
    public static final String PROP_USE_RANDSEED = "useRandSeed";
    private boolean useRandSeed;
    Random r;

    public Dither(double d, boolean bl, double d2, double d3) {
        this.initLogger();
        this.ditherMax = d;
        this.useRandSeed = bl;
        this.maxValue = d2;
        this.minValue = d3;
        this.initialize();
    }

    public Dither() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.ditherMax = propertySheet.getDouble(PROP_MAX_DITHER);
        this.useRandSeed = propertySheet.getBoolean(PROP_USE_RANDSEED);
        this.maxValue = propertySheet.getDouble(PROP_MAX_VAL);
        this.minValue = propertySheet.getDouble(PROP_MIN_VAL);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.r = this.useRandSeed ? new Random() : new Random(12345L);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && this.ditherMax != 0.0 && (data instanceof DoubleData || data instanceof FloatData)) {
            data = this.process(data);
        }
        return data;
    }

    private DoubleData process(Data data) throws IllegalArgumentException {
        assert (data instanceof DoubleData);
        DoubleData doubleData = (DoubleData)data;
        double[] dArray = doubleData.getValues();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = (double)(this.r.nextFloat() * 2.0f) * this.ditherMax - this.ditherMax + dArray[i];
            dArray2[i] = Math.max(Math.min(dArray2[i], this.maxValue), this.minValue);
        }
        DoubleData doubleData2 = new DoubleData(dArray2, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        return doubleData2;
    }
}

