/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.filter;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;

public class EnergyFilter
extends BaseDataProcessor {
    @S4Double(defaultValue=2.0)
    public static final String PROP_MAX_ENERGY = "maxEnergy";
    private double maxEnergy;

    public EnergyFilter(double d) {
        this.initLogger();
        this.maxEnergy = d;
        this.initialize();
    }

    public EnergyFilter() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.maxEnergy = propertySheet.getDouble(PROP_MAX_ENERGY);
    }

    @Override
    public Data getData() throws DataProcessingException {
        float f = 0.0f;
        Data data = null;
        do {
            if ((data = this.getPredecessor().getData()) == null || !(data instanceof DoubleData)) {
                return data;
            }
            f = 0.0f;
            for (double d : ((DoubleData)data).getValues()) {
                f = (float)((double)f + d * d);
            }
        } while ((double)f < this.maxEnergy);
        return data;
    }
}

