/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.filter;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;

public class Preemphasizer
extends BaseDataProcessor {
    @S4Double(defaultValue=0.97)
    public static final String PROP_PREEMPHASIS_FACTOR = "factor";
    private double preemphasisFactor;
    private double prior;

    public Preemphasizer(double d) {
        this.initLogger();
        this.preemphasisFactor = d;
    }

    public Preemphasizer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.preemphasisFactor = propertySheet.getDouble(PROP_PREEMPHASIS_FACTOR);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null) {
            if (data instanceof DoubleData) {
                this.applyPreemphasis(((DoubleData)data).getValues());
            } else if (data instanceof DataEndSignal || data instanceof SpeechEndSignal) {
                this.prior = 0.0;
            }
        }
        return data;
    }

    private void applyPreemphasis(double[] dArray) {
        double d = this.prior;
        if (dArray.length > 0) {
            d = dArray[dArray.length - 1];
        }
        if (dArray.length > 1 && this.preemphasisFactor != 0.0) {
            double d2 = dArray[0];
            dArray[0] = d2 - this.preemphasisFactor * this.prior;
            for (int i = 1; i < dArray.length; ++i) {
                double d3 = dArray[i];
                dArray[i] = d3 - this.preemphasisFactor * d2;
                d2 = d3;
            }
        }
        this.prior = d;
    }
}

