/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import java.util.Arrays;

public class LinearPredictor {
    private int order;
    private int cepstrumOrder;
    private double[] reflectionCoeffs;
    private double[] ARParameters;
    private double alpha;
    private double[] cepstra;
    private final double[] bilinearCepstra;

    public LinearPredictor(int n) {
        this.order = n;
        this.reflectionCoeffs = null;
        this.ARParameters = null;
        this.alpha = 0.0;
        this.cepstra = null;
        this.bilinearCepstra = null;
    }

    public double[] getARFilter(double[] dArray) {
        if (dArray[0] == 0.0) {
            return null;
        }
        this.reflectionCoeffs = new double[this.order + 1];
        this.ARParameters = new double[this.order + 1];
        double[] dArray2 = new double[this.order + 1];
        this.alpha = dArray[0];
        this.reflectionCoeffs[1] = -dArray[1] / dArray[0];
        this.ARParameters[0] = 1.0;
        this.ARParameters[1] = this.reflectionCoeffs[1];
        this.alpha *= 1.0 - this.reflectionCoeffs[1] * this.reflectionCoeffs[1];
        for (int i = 2; i <= this.order; ++i) {
            int n;
            for (n = 1; n < i; ++n) {
                dArray2[n] = this.ARParameters[i - n];
            }
            this.reflectionCoeffs[i] = 0.0;
            for (n = 0; n < i; ++n) {
                int n2 = i;
                this.reflectionCoeffs[n2] = this.reflectionCoeffs[n2] - this.ARParameters[n] * dArray[i - n];
            }
            int n3 = i;
            this.reflectionCoeffs[n3] = this.reflectionCoeffs[n3] / this.alpha;
            for (n = 1; n < i; ++n) {
                int n4 = n;
                this.ARParameters[n4] = this.ARParameters[n4] + this.reflectionCoeffs[i] * dArray2[n];
            }
            this.ARParameters[i] = this.reflectionCoeffs[i];
            this.alpha *= 1.0 - this.reflectionCoeffs[i] * this.reflectionCoeffs[i];
            if (!(this.alpha <= 0.0)) continue;
            return null;
        }
        return this.ARParameters;
    }

    public double[] reflectionCoeffsToARParameters(double[] dArray, int n) {
        int n2;
        double[][] dArray2 = new double[n + 1][n + 1];
        this.order = n;
        this.reflectionCoeffs = (double[])dArray.clone();
        for (n2 = 1; n2 <= n; ++n2) {
            for (int i = 1; i < n2; ++i) {
                dArray2[n2][i] = dArray2[n2 - 1][i] - dArray[n2] * dArray2[n2 - 1][n2 - i];
            }
            dArray2[n2][n2] = dArray[n2];
        }
        this.ARParameters[0] = 1.0;
        for (n2 = 1; n2 <= n; ++n2) {
            this.ARParameters[n2] = dArray2[n2][n2];
        }
        return this.ARParameters;
    }

    public double[] getData(int n) {
        int n2;
        double d;
        int n3;
        if (n <= 0) {
            return null;
        }
        this.cepstrumOrder = n;
        this.cepstra = new double[this.cepstrumOrder];
        this.cepstra[0] = Math.log(this.alpha);
        if (this.cepstrumOrder == 1) {
            return this.cepstra;
        }
        this.cepstra[1] = -this.ARParameters[1];
        for (n3 = 2; n3 < Math.min(this.cepstrumOrder, this.order + 1); ++n3) {
            d = (double)n3 * this.ARParameters[n3];
            for (n2 = 1; n2 < n3; ++n2) {
                d += this.ARParameters[n2] * this.cepstra[n3 - n2] * (double)(n3 - n2);
            }
            this.cepstra[n3] = -d / (double)n3;
        }
        while (n3 < this.cepstrumOrder) {
            d = 0.0;
            for (n2 = 1; n2 <= this.order; ++n2) {
                d += this.ARParameters[n2] * this.cepstra[n3 - n2] * (double)(n3 - n2);
            }
            this.cepstra[n3] = -d / (double)n3;
            ++n3;
        }
        return this.cepstra;
    }

    public double[] getBilinearCepstra(double d, int n) {
        int n2;
        double[][] dArray = new double[n][this.cepstrumOrder];
        double[] dArray2 = Arrays.copyOf(this.cepstra, this.cepstrumOrder);
        this.bilinearCepstra[0] = dArray2[0];
        dArray2[0] = 0.0;
        dArray[0][this.cepstrumOrder - 1] = dArray2[this.cepstrumOrder - 1];
        for (n2 = 1; n2 < n; ++n2) {
            dArray[n2][this.cepstrumOrder - 1] = 0.0;
        }
        for (n2 = this.cepstrumOrder - 2; n2 >= 0; --n2) {
            dArray[0][n2] = d * dArray[0][n2 + 1] + dArray2[n2];
            dArray[1][n2] = (1.0 - d * d) * dArray[0][n2 + 1] + d * dArray[1][n2 + 1];
            for (int i = 2; i < n; ++i) {
                dArray[i][n2] = d * (dArray[i][n2 + 1] - dArray[i - 1][n2]) + dArray[i - 1][n2 + 1];
            }
        }
        for (n2 = 1; n2 <= n; ++n2) {
            this.bilinearCepstra[n2] = dArray[n2][0];
        }
        return this.bilinearCepstra;
    }
}

