/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

public class MelFilter {
    private double[] weight;
    private int initialFreqIndex;

    public MelFilter(double d, double d2, double d3, double d4, double d5) throws IllegalArgumentException {
        if (d5 == 0.0) {
            throw new IllegalArgumentException("deltaFreq has zero value");
        }
        if (Math.round(d3 - d) == 0L || Math.round(d2 - d) == 0L || Math.round(d3 - d2) == 0L) {
            throw new IllegalArgumentException("Filter boundaries too close");
        }
        int n = (int)Math.round((d3 - d) / d5 + 1.0);
        if (n == 0) {
            throw new IllegalArgumentException("Number of elements in mel is zero.");
        }
        this.weight = new double[n];
        double d6 = 2.0 / (d3 - d);
        double d7 = d6 / (d2 - d);
        double d8 = d6 / (d2 - d3);
        double d9 = d4;
        int n2 = 0;
        while (d9 <= d3) {
            this.weight[n2] = d9 < d2 ? d7 * (d9 - d) : d6 + d8 * (d9 - d2);
            d9 += d5;
            ++n2;
        }
        this.initialFreqIndex = (int)Math.round(d4 / d5);
    }

    public double filterOutput(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            int n = this.initialFreqIndex + i;
            if (n >= dArray.length) continue;
            d += dArray[n] * this.weight[i];
        }
        return d;
    }
}

