/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.MelFilter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class MelFrequencyFilterBank
extends BaseDataProcessor {
    @S4Integer(defaultValue=40)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Double(defaultValue=130.0)
    public static final String PROP_MIN_FREQ = "minimumFrequency";
    @S4Double(defaultValue=6800.0)
    public static final String PROP_MAX_FREQ = "maximumFrequency";
    private int sampleRate;
    private int numberFftPoints;
    private int numberFilters;
    private double minFreq;
    private double maxFreq;
    private MelFilter[] filter;

    public MelFrequencyFilterBank(double d, double d2, int n) {
        this.initLogger();
        this.minFreq = d;
        this.maxFreq = d2;
        this.numberFilters = n;
    }

    public MelFrequencyFilterBank() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.minFreq = propertySheet.getDouble(PROP_MIN_FREQ);
        this.maxFreq = propertySheet.getDouble(PROP_MAX_FREQ);
        this.numberFilters = propertySheet.getInt(PROP_NUMBER_FILTERS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private double linToMelFreq(double d) {
        return 2595.0 * (Math.log(1.0 + d / 700.0) / Math.log(10.0));
    }

    private double melToLinFreq(double d) {
        return 700.0 * (Math.pow(10.0, d / 2595.0) - 1.0);
    }

    private double setToNearestFrequencyBin(double d, double d2) throws IllegalArgumentException {
        if (d2 == 0.0) {
            throw new IllegalArgumentException("stepFreq is zero");
        }
        return d2 * (double)Math.round(d / d2);
    }

    private void buildFilterbank(int n, int n2, double d, double d2) throws IllegalArgumentException {
        double d3;
        int n3;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        this.filter = new MelFilter[n2];
        if (n == 0) {
            throw new IllegalArgumentException("Number of FFT points is zero");
        }
        double d4 = (double)this.sampleRate / (double)n;
        if (n2 < 1) {
            throw new IllegalArgumentException("Number of filters illegal: " + n2);
        }
        double d5 = this.linToMelFreq(d);
        double d6 = this.linToMelFreq(d2);
        double d7 = (d6 - d5) / (double)(n2 + 1);
        dArray[0] = this.setToNearestFrequencyBin(d, d4);
        double d8 = d5;
        for (n3 = 0; n3 < n2; ++n3) {
            d3 = this.melToLinFreq(d8 += d7);
            dArray2[n3] = this.setToNearestFrequencyBin(d3, d4);
            if (n3 > 0) {
                dArray3[n3 - 1] = dArray2[n3];
            }
            if (n3 >= n2 - 1) continue;
            dArray[n3 + 1] = dArray2[n3];
        }
        d3 = this.melToLinFreq(d8 += d7);
        dArray3[n2 - 1] = this.setToNearestFrequencyBin(d3, d4);
        for (n3 = 0; n3 < n2; ++n3) {
            double d9 = this.setToNearestFrequencyBin(dArray[n3], d4);
            if (d9 < dArray[n3]) {
                d9 += d4;
            }
            this.filter[n3] = new MelFilter(dArray[n3], dArray2[n3], dArray3[n3], d9, d4);
        }
    }

    private DoubleData process(DoubleData doubleData) throws IllegalArgumentException {
        double[] dArray = doubleData.getValues();
        if (this.filter == null || this.sampleRate != doubleData.getSampleRate()) {
            this.numberFftPoints = dArray.length - 1 << 1;
            this.sampleRate = doubleData.getSampleRate();
            this.buildFilterbank(this.numberFftPoints, this.numberFilters, this.minFreq, this.maxFreq);
        } else if (dArray.length != (this.numberFftPoints >> 1) + 1) {
            throw new IllegalArgumentException("Window size is incorrect: in.length == " + dArray.length + ", numberFftPoints == " + ((this.numberFftPoints >> 1) + 1));
        }
        double[] dArray2 = new double[this.numberFilters];
        for (int i = 0; i < this.numberFilters; ++i) {
            dArray2[i] = this.filter[i].filterOutput(dArray);
        }
        DoubleData doubleData2 = new DoubleData(dArray2, this.sampleRate, doubleData.getFirstSampleNumber());
        return doubleData2;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            data = this.process((DoubleData)data);
        }
        return data;
    }
}

