/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.MelFilter2;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class MelFrequencyFilterBank2
extends BaseDataProcessor {
    @S4Integer(defaultValue=40)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Double(defaultValue=130.0)
    public static final String PROP_MIN_FREQ = "minimumFrequency";
    @S4Double(defaultValue=6800.0)
    public static final String PROP_MAX_FREQ = "maximumFrequency";
    private int sampleRate;
    private int numberFilters;
    private double minFreq;
    private double maxFreq;
    private MelFilter2[] filters;

    public MelFrequencyFilterBank2(double d, double d2, int n) {
        this.initLogger();
        this.minFreq = d;
        this.maxFreq = d2;
        this.numberFilters = n;
    }

    public MelFrequencyFilterBank2() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.minFreq = propertySheet.getDouble(PROP_MIN_FREQ);
        this.maxFreq = propertySheet.getDouble(PROP_MAX_FREQ);
        this.numberFilters = propertySheet.getInt(PROP_NUMBER_FILTERS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private double linearToMel(double d) {
        return 1127.0 * Math.log1p(d / 700.0);
    }

    private void buildFilterbank(int n, int n2, double d, double d2) throws IllegalArgumentException {
        int n3;
        assert (n > 0);
        assert (n2 > 0);
        double d3 = this.linearToMel(d);
        double d4 = this.linearToMel(d2);
        double d5 = (d4 - d3) / (double)(n2 + 1);
        double d6 = (double)this.sampleRate / (double)n;
        double[] dArray = new double[n / 2];
        this.filters = new MelFilter2[n2];
        for (n3 = 0; n3 < n / 2; ++n3) {
            dArray[n3] = this.linearToMel((double)n3 * d6);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            double d7 = d3 + (double)(n3 + 1) * d5;
            this.filters[n3] = new MelFilter2(d7, d5, dArray);
        }
    }

    private DoubleData process(DoubleData doubleData) throws IllegalArgumentException {
        double[] dArray = doubleData.getValues();
        int n = dArray.length - 1 << 1;
        if (this.filters == null || this.sampleRate != doubleData.getSampleRate()) {
            this.sampleRate = doubleData.getSampleRate();
            this.buildFilterbank(n, this.numberFilters, this.minFreq, this.maxFreq);
        } else if (dArray.length != (n >> 1) + 1) {
            throw new IllegalArgumentException("Window size is incorrect: in.length == " + dArray.length + ", numberFftPoints == " + ((n >> 1) + 1));
        }
        double[] dArray2 = new double[this.numberFilters];
        for (int i = 0; i < this.numberFilters; ++i) {
            dArray2[i] = this.filters[i].apply(dArray);
        }
        DoubleData doubleData2 = new DoubleData(dArray2, this.sampleRate, doubleData.getFirstSampleNumber());
        return doubleData2;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            data = this.process((DoubleData)data);
        }
        return data;
    }
}

