/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.LinearPredictor;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;

public class PLPCepstrumProducer
extends BaseDataProcessor {
    @S4Integer(defaultValue=32)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    @S4Integer(defaultValue=14)
    public static final String PROP_LPC_ORDER = "lpcOrder";
    private int cepstrumSize;
    private int LPCOrder;
    private int numberPLPFilters;
    private double[][] cosine;

    public PLPCepstrumProducer(int n, int n2, int n3) {
        this.initLogger();
        this.numberPLPFilters = n;
        this.cepstrumSize = n2;
        this.LPCOrder = n3;
    }

    public PLPCepstrumProducer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.numberPLPFilters = propertySheet.getInt(PROP_NUMBER_FILTERS);
        this.cepstrumSize = propertySheet.getInt(PROP_CEPSTRUM_LENGTH);
        this.LPCOrder = propertySheet.getInt(PROP_LPC_ORDER);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.computeCosine();
    }

    private void computeCosine() {
        this.cosine = new double[this.LPCOrder + 1][this.numberPLPFilters];
        double d = 2.0 * (double)this.numberPLPFilters;
        for (int i = 0; i <= this.LPCOrder; ++i) {
            double d2 = Math.PI * 2 * (double)i / d;
            for (int j = 0; j < this.numberPLPFilters; ++j) {
                this.cosine[i][j] = Math.cos(d2 * ((double)j + 0.5));
            }
        }
    }

    private double[] powerLawCompress(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.pow(dArray[i], 0.3333333333333333);
        }
        return dArray2;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        Data data2 = data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            data2 = this.process((DoubleData)data);
        }
        return data2;
    }

    private Data process(DoubleData doubleData) throws IllegalArgumentException {
        double[] dArray = doubleData.getValues();
        if (dArray.length != this.numberPLPFilters) {
            throw new IllegalArgumentException("PLPSpectrum size is incorrect: plpspectrum.length == " + dArray.length + ", numberPLPFilters == " + this.numberPLPFilters);
        }
        double[] dArray2 = this.powerLawCompress(dArray);
        double[] dArray3 = this.applyCosine(dArray2);
        LinearPredictor linearPredictor = new LinearPredictor(this.LPCOrder);
        linearPredictor.getARFilter(dArray3);
        double[] dArray4 = linearPredictor.getData(this.cepstrumSize);
        DoubleData doubleData2 = new DoubleData(dArray4, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        return doubleData2;
    }

    private double[] applyCosine(double[] dArray) {
        double[] dArray2 = new double[this.LPCOrder + 1];
        double d = this.numberPLPFilters;
        double d2 = 0.5;
        for (int i = 0; i <= this.LPCOrder; ++i) {
            if (this.numberPLPFilters <= 0) continue;
            double[] dArray3 = this.cosine[i];
            int n = 0;
            int n2 = i;
            dArray2[n2] = dArray2[n2] + d2 * dArray[n] * dArray3[n];
            for (n = 1; n < this.numberPLPFilters; ++n) {
                int n3 = i;
                dArray2[n3] = dArray2[n3] + dArray[n] * dArray3[n];
            }
            int n4 = i;
            dArray2[n4] = dArray2[n4] / d;
        }
        return dArray2;
    }
}

