/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.frequencywarp.FrequencyWarper;

public class PLPFilter {
    private double[] filterCoefficients;
    private final int numDFTPoints;
    public final double centerFreqInHz;
    public final double centerFreqInBark;

    public PLPFilter(double[] dArray, double d) throws IllegalArgumentException {
        FrequencyWarper frequencyWarper = new FrequencyWarper();
        this.numDFTPoints = dArray.length;
        this.centerFreqInHz = d;
        this.centerFreqInBark = frequencyWarper.hertzToBark(d);
        if (d < dArray[0] || d > dArray[this.numDFTPoints - 1]) {
            throw new IllegalArgumentException("Center frequency for PLP filter out of range");
        }
        this.filterCoefficients = new double[this.numDFTPoints];
        for (int i = 0; i < this.numDFTPoints; ++i) {
            double d2 = frequencyWarper.hertzToBark(dArray[i]) - this.centerFreqInBark;
            this.filterCoefficients[i] = d2 < -2.5 ? 0.0 : (d2 <= -0.5 ? Math.pow(10.0, d2 + 0.5) : (d2 <= 0.5 ? 1.0 : (d2 <= 1.3 ? Math.pow(10.0, -2.5 * (d2 - 0.5)) : 0.0)));
        }
    }

    public double filterOutput(double[] dArray) throws IllegalArgumentException {
        if (dArray.length != this.numDFTPoints) {
            throw new IllegalArgumentException("Mismatch in no. of DFT points " + dArray.length + " in spectrum and in filter " + this.numDFTPoints);
        }
        double d = 0.0;
        for (int i = 0; i < this.numDFTPoints; ++i) {
            d += dArray[i] * this.filterCoefficients[i];
        }
        return d;
    }
}

