/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.FrequencyWarper;
import edu.cmu.sphinx.frontend.frequencywarp.PLPFilter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class PLPFrequencyFilterBank
extends BaseDataProcessor {
    @S4Integer(defaultValue=32)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Double(defaultValue=130.0)
    public static final String PROP_MIN_FREQ = "minimumFrequency";
    @S4Double(defaultValue=3600.0)
    public static final String PROP_MAX_FREQ = "maximumFrequency";
    private int sampleRate;
    private int numberFftPoints;
    private int numberFilters;
    private double minFreq;
    private double maxFreq;
    private PLPFilter[] criticalBandFilter;
    private double[] equalLoudnessScaling;

    public PLPFrequencyFilterBank(double d, double d2, int n) {
        this.initLogger();
        this.minFreq = d;
        this.maxFreq = d2;
        this.numberFilters = n;
    }

    public PLPFrequencyFilterBank() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.minFreq = propertySheet.getDouble(PROP_MIN_FREQ);
        this.maxFreq = propertySheet.getDouble(PROP_MAX_FREQ);
        this.numberFilters = propertySheet.getInt(PROP_NUMBER_FILTERS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private void buildCriticalBandFilterbank() throws IllegalArgumentException {
        int n;
        int n2 = (this.numberFftPoints >> 1) + 1;
        FrequencyWarper frequencyWarper = new FrequencyWarper();
        this.criticalBandFilter = new PLPFilter[this.numberFilters];
        if (this.numberFftPoints == 0) {
            throw new IllegalArgumentException("Number of FFT points is zero");
        }
        if (this.numberFilters < 1) {
            throw new IllegalArgumentException("Number of filters illegal: " + this.numberFilters);
        }
        double[] dArray = new double[n2];
        double d = this.sampleRate / 2;
        for (n = 0; n < n2; ++n) {
            dArray[n] = (double)n * d / (double)(n2 - 1);
        }
        double d2 = frequencyWarper.hertzToBark(this.minFreq);
        double d3 = frequencyWarper.hertzToBark(this.maxFreq);
        if (this.numberFilters < 1) {
            throw new IllegalArgumentException("Number of filters illegal: " + this.numberFilters);
        }
        double d4 = (d3 - d2) / (double)(this.numberFilters + 1);
        for (n = 0; n < this.numberFilters; ++n) {
            double d5 = frequencyWarper.barkToHertz(d2 + (double)n * d4);
            this.criticalBandFilter[n] = new PLPFilter(dArray, d5);
        }
    }

    private double loudnessScalingFunction(double d) {
        double d2 = d * d;
        double d3 = d2 / (d2 + 160000.0);
        return d3 * d3 * ((d2 + 1440000.0) / (d2 + 9610000.0));
    }

    private void buildEqualLoudnessScalingFactors() {
        this.equalLoudnessScaling = new double[this.numberFilters];
        for (int i = 0; i < this.numberFilters; ++i) {
            double d = this.criticalBandFilter[i].centerFreqInHz;
            this.equalLoudnessScaling[i] = this.loudnessScalingFunction(d);
        }
    }

    private DoubleData process(DoubleData doubleData) throws IllegalArgumentException {
        double[] dArray = doubleData.getValues();
        if (this.criticalBandFilter == null || this.sampleRate != doubleData.getSampleRate()) {
            this.numberFftPoints = dArray.length - 1 << 1;
            this.sampleRate = doubleData.getSampleRate();
            this.buildCriticalBandFilterbank();
            this.buildEqualLoudnessScalingFactors();
        } else if (dArray.length != (this.numberFftPoints >> 1) + 1) {
            throw new IllegalArgumentException("Window size is incorrect: in.length == " + dArray.length + ", numberFftPoints == " + ((this.numberFftPoints >> 1) + 1));
        }
        double[] dArray2 = new double[this.numberFilters];
        for (int i = 0; i < this.numberFilters; ++i) {
            dArray2[i] = this.criticalBandFilter[i].filterOutput(dArray);
            int n = i;
            dArray2[n] = dArray2[n] * this.equalLoudnessScaling[i];
        }
        DoubleData doubleData2 = new DoubleData(dArray2, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        return doubleData2;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            data = this.process((DoubleData)data);
        }
        return data;
    }
}

