/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;

public class DiscreteCosineTransform
extends BaseDataProcessor {
    @S4Integer(defaultValue=40)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    protected int cepstrumSize;
    protected int numberMelFilters;
    protected double[][] melcosine;
    static final double LOG_FLOOR = 1.0E-4;

    public DiscreteCosineTransform(int n, int n2) {
        this.initLogger();
        this.numberMelFilters = n;
        this.cepstrumSize = n2;
    }

    public DiscreteCosineTransform() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.numberMelFilters = propertySheet.getInt(PROP_NUMBER_FILTERS);
        this.cepstrumSize = propertySheet.getInt(PROP_CEPSTRUM_LENGTH);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            data = this.process((DoubleData)data);
        }
        return data;
    }

    private DoubleData process(DoubleData doubleData) throws IllegalArgumentException {
        double[] dArray = doubleData.getValues();
        if (this.melcosine == null) {
            this.numberMelFilters = dArray.length;
            this.computeMelCosine();
        } else if (dArray.length != this.numberMelFilters) {
            throw new IllegalArgumentException("MelSpectrum size is incorrect: melspectrum.length == " + dArray.length + ", numberMelFilters == " + this.numberMelFilters);
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.log(dArray[i] + 1.0E-4);
        }
        double[] dArray2 = this.applyMelCosine(dArray);
        return new DoubleData(dArray2, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
    }

    protected void computeMelCosine() {
        this.melcosine = new double[this.cepstrumSize][this.numberMelFilters];
        double d = 2.0 * (double)this.numberMelFilters;
        for (int i = 0; i < this.cepstrumSize; ++i) {
            double d2 = Math.PI * 2 * (double)i / d;
            for (int j = 0; j < this.numberMelFilters; ++j) {
                this.melcosine[i][j] = Math.cos(d2 * ((double)j + 0.5));
            }
        }
    }

    protected double[] applyMelCosine(double[] dArray) {
        double[] dArray2 = new double[this.cepstrumSize];
        double d = this.numberMelFilters;
        double d2 = 0.5;
        for (int i = 0; i < dArray2.length; ++i) {
            if (this.numberMelFilters <= 0) continue;
            double[] dArray3 = this.melcosine[i];
            int n = 0;
            int n2 = i;
            dArray2[n2] = dArray2[n2] + d2 * dArray[n] * dArray3[n];
            for (n = 1; n < this.numberMelFilters; ++n) {
                int n3 = i;
                dArray2[n3] = dArray2[n3] + dArray[n] * dArray3[n];
            }
            int n4 = i;
            dArray2[n4] = dArray2[n4] / d;
        }
        return dArray2;
    }
}

