/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.Complex;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;

public class DiscreteFourierTransform
extends BaseDataProcessor {
    @S4Integer(defaultValue=-1)
    public static final String PROP_NUMBER_FFT_POINTS = "numberFftPoints";
    @S4Boolean(defaultValue=false)
    public static final String PROP_INVERT = "invert";
    private boolean isNumberFftPointsSet;
    private int numberFftPoints;
    private int logBase2NumberFftPoints;
    private int numberDataPoints;
    private boolean invert;
    private Complex[] weightFft;
    private Complex[] inputFrame;
    private Complex[] from;
    private Complex[] to;
    private Complex weightFftTimesFrom2;
    private Complex tempComplex;

    public DiscreteFourierTransform(int n, boolean bl) {
        this.initLogger();
        this.numberFftPoints = n;
        this.isNumberFftPointsSet = n != -1;
        this.invert = bl;
    }

    public DiscreteFourierTransform() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.logger = propertySheet.getLogger();
        this.numberFftPoints = propertySheet.getInt(PROP_NUMBER_FFT_POINTS);
        this.isNumberFftPointsSet = this.numberFftPoints != -1;
        this.invert = propertySheet.getBoolean(PROP_INVERT);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isNumberFftPointsSet) {
            this.initializeFFT();
        }
    }

    private void initializeFFT() {
        this.computeLogBase2(this.numberFftPoints);
        this.createWeightFft(this.numberFftPoints, this.invert);
        this.initComplexArrays();
        this.weightFftTimesFrom2 = new Complex();
        this.tempComplex = new Complex();
    }

    private void initComplexArrays() {
        this.inputFrame = new Complex[this.numberFftPoints];
        this.from = new Complex[this.numberFftPoints];
        this.to = new Complex[this.numberFftPoints];
        for (int i = 0; i < this.numberFftPoints; ++i) {
            this.inputFrame[i] = new Complex();
            this.from[i] = new Complex();
            this.to[i] = new Complex();
        }
    }

    private DoubleData process(DoubleData doubleData) throws IllegalArgumentException {
        int n;
        double[] dArray = doubleData.getValues();
        if (this.numberFftPoints < dArray.length) {
            for (n = 0; n < this.numberFftPoints; ++n) {
                this.inputFrame[n].set(dArray[n], 0.0);
            }
            while (n < dArray.length) {
                this.tempComplex.set(dArray[n], 0.0);
                this.inputFrame[n % this.numberFftPoints].addComplex(this.inputFrame[n % this.numberFftPoints], this.tempComplex);
                ++n;
            }
        } else {
            for (n = 0; n < dArray.length; ++n) {
                this.inputFrame[n].set(dArray[n], 0.0);
            }
            while (n < this.numberFftPoints) {
                this.inputFrame[n].reset();
                ++n;
            }
        }
        double[] dArray2 = new double[(this.numberFftPoints >> 1) + 1];
        this.recurseFft(this.inputFrame, dArray2, this.numberFftPoints, this.invert);
        DoubleData doubleData2 = new DoubleData(dArray2, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        return doubleData2;
    }

    private void computeLogBase2(int n) throws IllegalArgumentException {
        this.logBase2NumberFftPoints = 0;
        int n2 = n;
        while (n2 > 1) {
            if (n2 % 2 != 0 || n < 0) {
                throw new IllegalArgumentException("Not a power of 2: " + n);
            }
            n2 >>= 1;
            ++this.logBase2NumberFftPoints;
        }
    }

    private void createWeightFft(int n, boolean bl) {
        this.weightFft = new Complex[n >> 1];
        double d = Math.PI * -2 / (double)n;
        if (bl) {
            d = -d;
        }
        for (int i = 0; i < n >> 1; ++i) {
            this.weightFft[i] = new Complex(Math.cos(d * (double)i), Math.sin(d * (double)i));
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            DoubleData doubleData = (DoubleData)data;
            if (!this.isNumberFftPointsSet) {
                if (this.numberDataPoints != doubleData.getValues().length) {
                    this.numberDataPoints = doubleData.getValues().length;
                    this.numberFftPoints = DiscreteFourierTransform.getNumberFftPoints(this.numberDataPoints);
                    this.initializeFFT();
                }
            } else if (this.numberDataPoints != doubleData.getValues().length) {
                this.numberDataPoints = doubleData.getValues().length;
                int n = DiscreteFourierTransform.getNumberFftPoints(this.numberDataPoints);
                if (n != this.numberFftPoints) {
                    this.logger.warning("User set numberFftPoints (" + this.numberFftPoints + ") is not ideal (" + n + ')');
                }
            }
            data = this.process(doubleData);
        }
        return data;
    }

    private static int getNumberFftPoints(int n) {
        int n2 = 1;
        while (n2 < n) {
            if ((n2 <<= 1) >= 1) continue;
            throw new Error("Invalid # of FFT points: " + n2);
        }
        return n2;
    }

    private void recurseFft(Complex[] complexArray, double[] dArray, int n, boolean bl) {
        int n2;
        double d = !bl ? 1.0 : (double)n;
        for (n2 = 0; n2 < n; ++n2) {
            this.to[n2].reset();
            this.from[n2].scaleComplex(complexArray[n2], d);
        }
        this.butterflyStage(this.from, this.to, n, n >> 1);
        if ((this.logBase2NumberFftPoints & 1) == 0) {
            for (n2 = 0; n2 <= n >> 1; ++n2) {
                dArray[n2] = this.from[n2].squaredMagnitudeComplex();
            }
        } else {
            for (n2 = 0; n2 <= n >> 1; ++n2) {
                dArray[n2] = this.to[n2].squaredMagnitudeComplex();
            }
        }
    }

    private void butterflyStage(Complex[] complexArray, Complex[] complexArray2, int n, int n2) {
        if (n2 > 0) {
            int n3 = 2 * n2;
            for (int i = 0; i < n2; ++i) {
                int n4 = i;
                int n5 = i + n2;
                int n6 = i;
                int n7 = i + (n >> 1);
                for (int j = 0; j < n >> 1; j += n2) {
                    this.weightFftTimesFrom2.multiplyComplex(this.weightFft[j], complexArray[n5]);
                    complexArray2[n6].addComplex(complexArray[n4], this.weightFftTimesFrom2);
                    complexArray2[n7].subtractComplex(complexArray[n4], this.weightFftTimesFrom2);
                    n4 += n3;
                    n5 += n3;
                    n6 += n2;
                    n7 += n2;
                }
            }
            this.butterflyStage(complexArray2, complexArray, n, n2 >> 1);
        }
    }
}

