/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform;
import java.util.Arrays;

public class KaldiDiscreteCosineTransform
extends DiscreteCosineTransform {
    public KaldiDiscreteCosineTransform(int n, int n2) {
        super(n, n2);
    }

    public KaldiDiscreteCosineTransform() {
    }

    @Override
    protected void computeMelCosine() {
        this.melcosine = new double[this.cepstrumSize][this.numberMelFilters];
        Arrays.fill(this.melcosine[0], Math.sqrt(1.0 / (double)this.numberMelFilters));
        double d = Math.sqrt(2.0 / (double)this.numberMelFilters);
        for (int i = 1; i < this.cepstrumSize; ++i) {
            double d2 = Math.PI * (double)i / (double)this.numberMelFilters;
            for (int j = 0; j < this.numberMelFilters; ++j) {
                this.melcosine[i][j] = d * Math.cos(d2 * ((double)j + 0.5));
            }
        }
    }

    @Override
    protected double[] applyMelCosine(double[] dArray) {
        double[] dArray2 = new double[this.cepstrumSize];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < this.numberMelFilters; ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[j] * this.melcosine[i][j];
            }
        }
        return dArray2;
    }
}

