/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;

public class AudioContinuityTester
extends BaseDataProcessor {
    long lastSampleNum = -1L;

    public AudioContinuityTester() {
        this.initLogger();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        assert (this.isAudioStreamContinuous(data)) : "audio stream is not continuous";
        return data;
    }

    private boolean isAudioStreamContinuous(Data data) {
        if (data instanceof DoubleData) {
            DoubleData doubleData = (DoubleData)data;
            if (this.lastSampleNum != -1L && this.lastSampleNum != doubleData.getFirstSampleNumber()) {
                return false;
            }
            this.lastSampleNum = doubleData.getFirstSampleNumber() + (long)doubleData.getValues().length;
        } else if (data instanceof DataStartSignal) {
            this.lastSampleNum = -1L;
        }
        return true;
    }
}

