/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.AudioFileProcessListener;
import edu.cmu.sphinx.frontend.util.ConcatAudioFileDataSource;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileDataSource
extends BaseDataProcessor {
    @S4Integer(defaultValue=3200)
    public static final String PROP_BYTES_PER_READ = "bytesPerRead";
    @S4ComponentList(type=Configurable.class)
    public static final String AUDIO_FILE_LISTENERS = "audioFileListners";
    protected final List<AudioFileProcessListener> fileListeners = new ArrayList<AudioFileProcessListener>();
    protected InputStream dataStream;
    protected int sampleRate;
    protected int bytesPerRead;
    protected int bytesPerValue;
    private long totalValuesRead;
    protected boolean bigEndian;
    protected boolean signedData;
    private boolean streamEndReached;
    private boolean utteranceEndSent;
    private boolean utteranceStarted;
    private File curAudioFile;

    public AudioFileDataSource(int n, List<AudioFileProcessListener> list) {
        this.initLogger();
        this.create(n, list);
    }

    public AudioFileDataSource() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.logger = propertySheet.getLogger();
        this.create(propertySheet.getInt(PROP_BYTES_PER_READ), propertySheet.getComponentList(AUDIO_FILE_LISTENERS, AudioFileProcessListener.class));
    }

    private void create(int n, List<AudioFileProcessListener> list) {
        this.bytesPerRead = n;
        if (list != null) {
            for (AudioFileProcessListener audioFileProcessListener : list) {
                this.addNewFileListener(audioFileProcessListener);
            }
        }
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.streamEndReached = false;
        this.utteranceEndSent = false;
        this.utteranceStarted = false;
        if (this.bytesPerRead % 2 == 1) {
            ++this.bytesPerRead;
        }
    }

    public void setAudioFile(File file, String string) {
        try {
            this.setAudioFile(file.toURI().toURL(), string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void setAudioFile(URL uRL, String string) {
        if (this.dataStream != null) {
            try {
                this.dataStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.dataStream = null;
        }
        assert (uRL != null);
        if (string != null) {
            string = uRL.getPath();
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(uRL);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.err.println("Audio file format not supported: " + unsupportedAudioFileException);
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.curAudioFile = new File(uRL.getFile());
        for (AudioFileProcessListener audioFileProcessListener : this.fileListeners) {
            audioFileProcessListener.audioFileProcStarted(this.curAudioFile);
        }
        this.setInputStream(audioInputStream, string);
    }

    public void setInputStream(AudioInputStream audioInputStream, String string) {
        this.dataStream = audioInputStream;
        this.streamEndReached = false;
        this.utteranceEndSent = false;
        this.utteranceStarted = false;
        AudioFormat audioFormat = audioInputStream.getFormat();
        this.sampleRate = (int)audioFormat.getSampleRate();
        this.bigEndian = audioFormat.isBigEndian();
        String string2 = audioFormat.toString();
        this.logger.finer("input format is " + string2);
        if (audioFormat.getSampleSizeInBits() % 8 != 0) {
            throw new Error("StreamDataSource: bits per sample must be a multiple of 8.");
        }
        this.bytesPerValue = audioFormat.getSampleSizeInBits() / 8;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.signedData = true;
        } else if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            this.signedData = false;
        } else {
            throw new RuntimeException("used file encoding is not supported");
        }
        this.totalValuesRead = 0L;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        if (this.streamEndReached) {
            if (!this.utteranceEndSent) {
                data = this.createDataEndSignal();
                this.utteranceEndSent = true;
            }
        } else if (!this.utteranceStarted) {
            this.utteranceStarted = true;
            data = new DataStartSignal(this.sampleRate);
        } else if (this.dataStream != null && (data = this.readNextFrame()) == null && !this.utteranceEndSent) {
            data = this.createDataEndSignal();
            this.utteranceEndSent = true;
        }
        return data;
    }

    private DataEndSignal createDataEndSignal() {
        if (!(this instanceof ConcatAudioFileDataSource)) {
            for (AudioFileProcessListener audioFileProcessListener : this.fileListeners) {
                audioFileProcessListener.audioFileProcFinished(this.curAudioFile);
            }
        }
        return new DataEndSignal(this.getDuration());
    }

    private Data readNextFrame() throws DataProcessingException {
        Object[] objectArray;
        int n = 0;
        int n2 = this.bytesPerRead;
        byte[] byArray = new byte[this.bytesPerRead];
        long l = this.totalValuesRead;
        try {
            int n3;
            do {
                if ((n3 = this.dataStream.read(byArray, n, n2 - n)) <= 0) continue;
                n += n3;
            } while (n3 != -1 && n < n2);
            if (n <= 0) {
                this.closeDataStream();
                return null;
            }
            this.totalValuesRead += (long)(n / this.bytesPerValue);
            if (n < n2) {
                n = n % 2 == 0 ? n + 2 : n + 3;
                objectArray = new byte[n];
                System.arraycopy(byArray, 0, objectArray, 0, n);
                byArray = objectArray;
                this.closeDataStream();
            }
        }
        catch (IOException iOException) {
            throw new DataProcessingException("Error reading data", iOException);
        }
        objectArray = this.bigEndian ? (Object[])DataUtil.bytesToValues(byArray, 0, n, this.bytesPerValue, this.signedData) : (Object[])DataUtil.littleEndianBytesToValues(byArray, 0, n, this.bytesPerValue, this.signedData);
        return new DoubleData((double[])objectArray, this.sampleRate, l);
    }

    private void closeDataStream() throws IOException {
        this.streamEndReached = true;
        if (this.dataStream != null) {
            this.dataStream.close();
        }
    }

    private long getDuration() {
        return (long)((double)this.totalValuesRead / (double)this.sampleRate * 1000.0);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void addNewFileListener(AudioFileProcessListener audioFileProcessListener) {
        if (audioFileProcessListener == null) {
            return;
        }
        this.fileListeners.add(audioFileProcessListener);
    }

    public void removeNewFileListener(AudioFileProcessListener audioFileProcessListener) {
        if (audioFileProcessListener == null) {
            return;
        }
        this.fileListeners.remove(audioFileProcessListener);
    }
}

