/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.util.AudioFileDataSource;
import edu.cmu.sphinx.frontend.util.AudioFileProcessListener;
import edu.cmu.sphinx.util.ReferenceSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ConcatAudioFileDataSource
extends AudioFileDataSource
implements ReferenceSource {
    private URL nextFile;
    private List<String> referenceList;
    private boolean isInitialized;
    List<URL> batchFiles;

    public ConcatAudioFileDataSource(int n, List<AudioFileProcessListener> list) {
        super(n, list);
    }

    public ConcatAudioFileDataSource() {
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.batchFiles == null) {
            return;
        }
        try {
            this.referenceList = new ArrayList<String>();
            this.dataStream = new SequenceInputStream(new InputStreamEnumeration(this.batchFiles));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setBatchFile(File file) {
        this.setBatchUrls(ConcatAudioFileDataSource.readDriver(file.getAbsolutePath()));
    }

    public void setBatchFiles(List<File> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            for (File file : list) {
                arrayList.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.setBatchUrls(arrayList);
    }

    public void setBatchUrls(List<URL> list) {
        this.batchFiles = new ArrayList<URL>(list);
        this.initialize();
    }

    private static List<URL> readDriver(String string) {
        File file = new File(string);
        ArrayList<URL> arrayList = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            arrayList = new ArrayList<URL>();
            while ((string2 = bufferedReader.readLine()) != null && string2.trim().length() != 0) {
                File file2 = new File(string2);
                arrayList.add(file2.toURI().toURL());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        assert (arrayList != null);
        return arrayList;
    }

    @Override
    public void setAudioFile(URL uRL, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getReferences() {
        return this.referenceList;
    }

    class InputStreamEnumeration
    implements Enumeration<AudioInputStream> {
        private URL lastFile;
        final Iterator<URL> fileIt;

        InputStreamEnumeration(List<URL> list) throws IOException {
            this.fileIt = new ArrayList<URL>(list).iterator();
        }

        @Override
        public boolean hasMoreElements() {
            if (ConcatAudioFileDataSource.this.nextFile == null) {
                ConcatAudioFileDataSource.this.nextFile = this.readNext();
            }
            return ConcatAudioFileDataSource.this.nextFile != null;
        }

        @Override
        public AudioInputStream nextElement() {
            AudioInputStream audioInputStream = null;
            if (this.lastFile == null) {
                ConcatAudioFileDataSource.this.nextFile = this.readNext();
            }
            if (ConcatAudioFileDataSource.this.nextFile != null) {
                try {
                    AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(ConcatAudioFileDataSource.this.nextFile);
                    AudioFormat audioFormat = audioInputStream2.getFormat();
                    if (!ConcatAudioFileDataSource.this.isInitialized) {
                        ConcatAudioFileDataSource.this.isInitialized = true;
                        ConcatAudioFileDataSource.this.bigEndian = audioFormat.isBigEndian();
                        ConcatAudioFileDataSource.this.sampleRate = (int)audioFormat.getSampleRate();
                        ConcatAudioFileDataSource.this.signedData = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                        ConcatAudioFileDataSource.this.bytesPerValue = audioFormat.getSampleSizeInBits() / 8;
                    }
                    if (audioFormat.getSampleRate() != (float)ConcatAudioFileDataSource.this.sampleRate || audioFormat.getChannels() != 1 || audioFormat.isBigEndian() != ConcatAudioFileDataSource.this.bigEndian) {
                        throw new RuntimeException("format mismatch for subsequent files");
                    }
                    audioInputStream = audioInputStream2;
                    ConcatAudioFileDataSource.this.logger.finer("Strating processing of '" + this.lastFile.getFile() + '\'');
                    for (AudioFileProcessListener audioFileProcessListener : ConcatAudioFileDataSource.this.fileListeners) {
                        audioFileProcessListener.audioFileProcStarted(new File(ConcatAudioFileDataSource.this.nextFile.getFile()));
                    }
                    this.lastFile = ConcatAudioFileDataSource.this.nextFile;
                    ConcatAudioFileDataSource.this.nextFile = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new Error("Cannot convert " + ConcatAudioFileDataSource.this.nextFile + " to a FileInputStream");
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    unsupportedAudioFileException.printStackTrace();
                }
            }
            return audioInputStream;
        }

        public URL readNext() {
            if (this.lastFile != null) {
                ConcatAudioFileDataSource.this.logger.finest("Finished processing of '" + this.lastFile.getFile() + '\'');
                for (AudioFileProcessListener audioFileProcessListener : ConcatAudioFileDataSource.this.fileListeners) {
                    audioFileProcessListener.audioFileProcFinished(new File(this.lastFile.getFile()));
                }
                this.lastFile = null;
            }
            if (this.fileIt.hasNext()) {
                this.lastFile = this.fileIt.next();
            }
            return this.lastFile;
        }
    }
}

