/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.util.BatchFile;
import edu.cmu.sphinx.util.ReferenceSource;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ConcatFileDataSource
extends StreamDataSource
implements ReferenceSource {
    @S4Integer(defaultValue=1)
    public static final String PROP_START_FILE = "startFile";
    @S4Integer(defaultValue=0)
    public static final String PROP_SKIP = "skip";
    @S4Integer(defaultValue=-1)
    public static final String PROP_TOTAL_FILES = "totalFiles";
    @S4String
    public static final String PROP_SILENCE_FILE = "silenceFile";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_RANDOM_SILENCE = "addRandomSilence";
    @S4Integer(defaultValue=3)
    public static final String PROP_MAX_SILENCE = "maxSilence";
    @S4String
    public static final String PROP_TRANSCRIPT_FILE = "transcriptFile";
    @S4String
    public static final String PROP_BATCH_FILE = "batchFile";
    private static final String GAP_LABEL = "inter_segment_gap";
    private boolean addRandomSilence;
    private int skip;
    private int maxSilence;
    private int silenceCount;
    private int bytesPerSecond;
    private long totalBytes;
    private long silenceFileLength;
    private String silenceFileName;
    private String nextFile;
    private String context;
    private String transcriptFile;
    private List<String> referenceList;
    private FileWriter transcript;
    private int startFile;
    private int totalFiles;
    private String batchFile;

    public ConcatFileDataSource(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, int n5, String string, int n6, int n7, String string2, String string3) {
        super(n, n2, n3, bl, bl2);
        this.bytesPerSecond = n * (n3 / 8);
        this.addRandomSilence = bl3;
        this.maxSilence = n4;
        this.skip = n5;
        this.silenceFileName = string;
        this.startFile = n6;
        this.totalFiles = n7;
        this.transcriptFile = string2;
        this.batchFile = string3;
    }

    public ConcatFileDataSource() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.bytesPerSecond = this.sampleRate * (this.bitsPerSample / 8);
        this.addRandomSilence = propertySheet.getBoolean(PROP_ADD_RANDOM_SILENCE);
        this.maxSilence = propertySheet.getInt(PROP_MAX_SILENCE);
        this.skip = propertySheet.getInt(PROP_SKIP);
        this.silenceFileName = propertySheet.getString(PROP_SILENCE_FILE);
        this.startFile = propertySheet.getInt(PROP_START_FILE);
        this.totalFiles = propertySheet.getInt(PROP_TOTAL_FILES);
        this.transcriptFile = propertySheet.getString(PROP_TRANSCRIPT_FILE);
        this.batchFile = propertySheet.getString(PROP_BATCH_FILE);
    }

    @Override
    public void initialize() {
        super.initialize();
        try {
            File file = new File(this.silenceFileName);
            this.silenceFileLength = file.length();
            if (this.transcriptFile != null) {
                this.transcript = new FileWriter(this.transcriptFile);
            }
            if (this.batchFile == null) {
                throw new Error("BatchFile cannot be null!");
            }
            this.setInputStream(new SequenceInputStream(new InputStreamEnumeration(this.batchFile, this.startFile, this.totalFiles)));
            this.referenceList = new LinkedList<String>();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public List<String> getReferences() {
        return this.referenceList;
    }

    public String getTranscriptFile() {
        return this.transcriptFile;
    }

    private float getSeconds(long l) {
        return (float)l / (float)this.bytesPerSecond;
    }

    class InputStreamEnumeration
    implements Enumeration<InputStream> {
        private final int totalFiles;
        private boolean inSilence;
        private Random silenceRandom;
        private BufferedReader reader;

        InputStreamEnumeration(String string, int n, int n2) throws IOException {
            this.totalFiles = n2;
            this.reader = new BufferedReader(new FileReader(string));
            if (ConcatFileDataSource.this.silenceFileName != null) {
                this.inSilence = true;
                this.silenceRandom = new Random(System.currentTimeMillis());
                ConcatFileDataSource.this.silenceCount = this.getSilenceCount();
            }
            for (int i = 1; i < n; ++i) {
                this.reader.readLine();
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (ConcatFileDataSource.this.nextFile == null) {
                ConcatFileDataSource.this.nextFile = this.readNext();
            }
            return ConcatFileDataSource.this.nextFile != null;
        }

        @Override
        public InputStream nextElement() {
            FileInputStream fileInputStream = null;
            if (ConcatFileDataSource.this.nextFile == null) {
                ConcatFileDataSource.this.nextFile = this.readNext();
            }
            if (ConcatFileDataSource.this.nextFile != null) {
                try {
                    fileInputStream = new FileInputStream(ConcatFileDataSource.this.nextFile);
                    ConcatFileDataSource.this.nextFile = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new Error("Cannot convert " + ConcatFileDataSource.this.nextFile + " to a FileInputStream");
                }
            }
            if (fileInputStream == null && ConcatFileDataSource.this.transcript != null) {
                try {
                    ConcatFileDataSource.this.transcript.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return fileInputStream;
        }

        public String readNext() {
            if (!this.inSilence) {
                return this.readNextDataFile();
            }
            String string = null;
            if (ConcatFileDataSource.this.silenceCount > 0) {
                string = ConcatFileDataSource.this.silenceFileName;
                if (ConcatFileDataSource.this.transcript != null) {
                    this.writeSilenceToTranscript();
                }
                ConcatFileDataSource.this.silenceCount--;
                if (ConcatFileDataSource.this.silenceCount <= 0) {
                    this.inSilence = false;
                }
            }
            return string;
        }

        private String readNextDataFile() {
            try {
                if (0 <= this.totalFiles && this.totalFiles <= ConcatFileDataSource.this.referenceList.size()) {
                    return null;
                }
                String string = this.reader.readLine();
                if (string != null) {
                    String string2 = BatchFile.getReference(string);
                    ConcatFileDataSource.this.referenceList.add(string2);
                    string = BatchFile.getFilename(string);
                    for (int i = 1; i < ConcatFileDataSource.this.skip; ++i) {
                        this.reader.readLine();
                    }
                    if (ConcatFileDataSource.this.silenceFileName != null && ConcatFileDataSource.this.maxSilence > 0) {
                        ConcatFileDataSource.this.silenceCount = this.getSilenceCount();
                        this.inSilence = true;
                    }
                    if (ConcatFileDataSource.this.transcript != null) {
                        this.writeTranscript(string, string2);
                    }
                }
                return string;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new Error("Problem reading from batch file");
            }
        }

        private void writeTranscript(String string, String string2) {
            try {
                File file = new File(string);
                float f = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource.this.totalBytes = ConcatFileDataSource.this.totalBytes + file.length();
                float f2 = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource.this.transcript.write(ConcatFileDataSource.this.context + " 1 " + string + ' ' + f + ' ' + f2 + "  " + string2 + '\n');
                ConcatFileDataSource.this.transcript.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void writeSilenceToTranscript() {
            try {
                float f = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource.this.totalBytes = ConcatFileDataSource.this.totalBytes + ConcatFileDataSource.this.silenceFileLength;
                float f2 = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource.this.transcript.write(ConcatFileDataSource.this.context + " 1 " + ConcatFileDataSource.GAP_LABEL + ' ' + f + ' ' + f2 + " \n");
                ConcatFileDataSource.this.transcript.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private int getSilenceCount() {
            if (ConcatFileDataSource.this.addRandomSilence) {
                return this.silenceRandom.nextInt(ConcatFileDataSource.this.maxSilence) + 1;
            }
            return ConcatFileDataSource.this.maxSilence;
        }
    }
}

