/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.MatrixUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;

public class DataConverter
extends BaseDataProcessor {
    public static final String CONVERT_D2F = "d2f";
    public static final String CONVERT_F2D = "f2d";
    @S4String(defaultValue="d2f", range={"d2f", "f2d"})
    public static final String PROP_CONVERSION_MODE = "conversionMode";
    private String convMode;

    public DataConverter(String string) throws PropertyException {
        this.initLogger();
        this.convMode = string;
    }

    public DataConverter() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.convMode = propertySheet.getString(PROP_CONVERSION_MODE);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data instanceof DoubleData && this.convMode.equals(CONVERT_D2F)) {
            DoubleData doubleData = (DoubleData)data;
            data = new FloatData(MatrixUtils.double2float(doubleData.getValues()), doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        } else if (data instanceof FloatData && this.convMode.equals(CONVERT_F2D)) {
            FloatData floatData = (FloatData)data;
            data = new DoubleData(MatrixUtils.float2double(floatData.getValues()), floatData.getSampleRate(), floatData.getFirstSampleNumber());
        }
        return data;
    }
}

