/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechClassifiedData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4String;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DataDumper
extends BaseDataProcessor {
    @S4String(defaultValue="0.00000E00;-0.00000E00")
    public static final String PROP_OUTPUT_FORMAT = "outputFormat";
    @S4Boolean(defaultValue=true)
    public static final String PROP_OUTPUT_SIGNALS = "outputSignals";
    private boolean outputSignals;
    private DecimalFormat formatter;

    public DataDumper(String string, boolean bl) {
        this.initLogger();
        this.formatter = new DecimalFormat(string, new DecimalFormatSymbols(Locale.US));
        this.outputSignals = bl;
    }

    public DataDumper() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.logger = propertySheet.getLogger();
        String string = propertySheet.getString(PROP_OUTPUT_FORMAT);
        this.formatter = new DecimalFormat(string, new DecimalFormatSymbols(Locale.US));
        this.outputSignals = propertySheet.getBoolean(PROP_OUTPUT_SIGNALS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        this.dumpData(data);
        return data;
    }

    private void dumpData(Data data) {
        if (data == null) {
            System.out.println("Data: null");
        } else if (data instanceof Signal) {
            if (this.outputSignals) {
                System.out.println("Signal: " + data);
            }
        } else if (data instanceof DoubleData) {
            DoubleData doubleData = (DoubleData)data;
            double[] dArray = doubleData.getValues();
            System.out.print("Frame " + dArray.length);
            for (double d : dArray) {
                System.out.print(' ' + this.formatter.format(d));
            }
            System.out.println();
        } else if (data instanceof SpeechClassifiedData) {
            SpeechClassifiedData speechClassifiedData = (SpeechClassifiedData)data;
            double[] dArray = speechClassifiedData.getValues();
            System.out.print("Frame ");
            if (speechClassifiedData.isSpeech()) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            System.out.print(" " + dArray.length);
            for (double d : dArray) {
                System.out.print(' ' + this.formatter.format(d));
            }
            System.out.println();
        } else if (data instanceof FloatData) {
            FloatData floatData = (FloatData)data;
            float[] fArray = floatData.getValues();
            System.out.print("Frame " + fArray.length);
            for (float f : fArray) {
                System.out.print(' ' + this.formatter.format(f));
            }
            System.out.println();
        }
    }
}

