/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.Utilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class DataUtil {
    private static final int HEXADECIMAL = 1;
    private static final int SCIENTIFIC = 2;
    private static final int DECIMAL = 3;
    private static final DecimalFormat format = new DecimalFormat();
    private static final int decimalIntegerDigits = 10;
    private static final int decimalFractionDigits = 5;
    private static final int floatScientificFractionDigits = 8;
    private static final int doubleScientificFractionDigits = 8;
    private static int dumpFormat = 2;

    private DataUtil() {
    }

    public static short[] byteToShortArray(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (0 < n2 && n + n2 <= byArray.length) {
            int n3 = n2 / 2;
            short[] sArray = new short[n3];
            int n4 = n;
            for (int i = 0; i < n3; ++i) {
                int n5 = byArray[n4++] << 8;
                sArray[i] = (short)(n5 |= 0xFF & byArray[n4++]);
                n5 = 0;
            }
            return sArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + n + ", length: " + n2 + ", array length: " + byArray.length);
    }

    public static double[] bytesToValues(byte[] byArray, int n, int n2, int n3, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (0 < n2 && n + n2 <= byArray.length) {
            assert (n2 % n3 == 0);
            double[] dArray = new double[n2 / n3];
            int n4 = n;
            for (int i = 0; i < dArray.length; ++i) {
                int n5 = byArray[n4++];
                if (!bl) {
                    n5 &= 0xFF;
                }
                for (int j = 1; j < n3; ++j) {
                    int n6 = byArray[n4++] & 0xFF;
                    n5 = (n5 << 8) + n6;
                }
                dArray[i] = n5;
            }
            return dArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + n + ", length: " + n2 + ", array length: " + byArray.length);
    }

    public static double[] littleEndianBytesToValues(byte[] byArray, int n, int n2, int n3, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (0 < n2 && n + n2 <= byArray.length) {
            assert (n2 % n3 == 0);
            double[] dArray = new double[n2 / n3];
            int n4 = n + n3 - 1;
            for (int i = 0; i < dArray.length; ++i) {
                int n5 = byArray[n4--];
                if (!bl) {
                    n5 &= 0xFF;
                }
                for (int j = 1; j < n3; ++j) {
                    int n6 = byArray[n4--] & 0xFF;
                    n5 = (n5 << 8) + n6;
                }
                n4 += n3 * 2;
                dArray[i] = n5;
            }
            return dArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + n + ", length: " + n2 + ", array length: " + byArray.length);
    }

    public static short bytesToShort(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        short s = (short)(byArray[n++] << 8 | 0xFF & byArray[n]);
        return s;
    }

    public static String shortArrayToString(short[] sArray) {
        StringBuilder stringBuilder = new StringBuilder().append(sArray.length);
        for (short s : sArray) {
            stringBuilder.append(' ').append(s);
        }
        return stringBuilder.toString();
    }

    public static String doubleArrayToString(double[] dArray) {
        return DataUtil.doubleArrayToString(dArray, dumpFormat);
    }

    private static String doubleArrayToString(double[] dArray, int n) {
        StringBuilder stringBuilder = new StringBuilder().append(dArray.length);
        for (double d : dArray) {
            if (n == 3) {
                stringBuilder.append(' ').append(DataUtil.formatDouble(d, 10, 5));
                continue;
            }
            if (n == 1) {
                long l = Double.doubleToRawLongBits(d);
                stringBuilder.append(" 0x").append(Long.toHexString(l));
                continue;
            }
            if (n != 2) continue;
            stringBuilder.append(' ').append(Utilities.doubleToScientificString(d, 8));
        }
        return stringBuilder.toString();
    }

    public static String floatArrayToString(float[] fArray) {
        return DataUtil.floatArrayToString(fArray, dumpFormat);
    }

    private static String floatArrayToString(float[] fArray, int n) {
        StringBuilder stringBuilder = new StringBuilder().append(fArray.length);
        for (float f : fArray) {
            if (n == 3) {
                stringBuilder.append(' ').append(DataUtil.formatDouble(f, 10, 5));
                continue;
            }
            if (n == 1) {
                int n2 = Float.floatToRawIntBits(f);
                stringBuilder.append(" 0x").append(Integer.toHexString(n2));
                continue;
            }
            if (n != 2) continue;
            stringBuilder.append(' ').append(Utilities.doubleToScientificString(f, 8));
        }
        return stringBuilder.toString();
    }

    public static String formatDouble(double d, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(2 + n2).append("0.");
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append('0');
        }
        format.applyPattern(stringBuilder.toString());
        String string = format.format(d);
        int n3 = string.indexOf(46);
        if (n3 == -1) {
            string = string + ".";
            n3 = string.length() - 1;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = n3; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder2.append(string);
        return stringBuilder2.toString();
    }

    public static int getSamplesPerWindow(int n, float f) {
        return (int)((float)n * f / 1000.0f);
    }

    public static int getSamplesPerShift(int n, float f) {
        return (int)((float)n * f / 1000.0f);
    }

    public static void bytesToFile(byte[] byArray, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static AudioFormat getNativeAudioFormat(AudioFormat audioFormat) {
        return DataUtil.getNativeAudioFormat(audioFormat, null);
    }

    public static AudioFormat getNativeAudioFormat(AudioFormat audioFormat, Mixer mixer) {
        Line.Info[] infoArray = mixer != null ? mixer.getTargetLineInfo(new Line.Info(TargetDataLine.class)) : AudioSystem.getTargetLineInfo(new Line.Info(TargetDataLine.class));
        AudioFormat audioFormat2 = null;
        for (Line.Info info : infoArray) {
            AudioFormat[] audioFormatArray;
            for (AudioFormat audioFormat3 : audioFormatArray = ((DataLine.Info)info).getFormats()) {
                if (audioFormat3.getEncoding() != audioFormat.getEncoding() || audioFormat3.isBigEndian() != audioFormat.isBigEndian() || audioFormat3.getSampleSizeInBits() != audioFormat.getSampleSizeInBits() || !(audioFormat3.getSampleRate() >= audioFormat.getSampleRate())) continue;
                audioFormat2 = audioFormat3;
                break;
            }
            if (audioFormat2 != null) break;
        }
        return audioFormat2;
    }

    public static DoubleData FloatData2DoubleData(FloatData floatData) {
        int n = floatData.getValues().length;
        double[] dArray = new double[n];
        float[] fArray = floatData.getValues();
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        return new DoubleData(dArray, floatData.getSampleRate(), floatData.getFirstSampleNumber());
    }

    public static FloatData DoubleData2FloatData(DoubleData doubleData) {
        int n = doubleData.getValues().length;
        float[] fArray = new float[n];
        double[] dArray = doubleData.getValues();
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return new FloatData(fArray, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
    }

    static {
        String string = System.getProperty("frontend.util.dumpformat", "SCIENTIFIC");
        if (string.compareToIgnoreCase("DECIMAL") == 0) {
            dumpFormat = 3;
        } else if (string.compareToIgnoreCase("HEXADECIMAL") == 0) {
            dumpFormat = 1;
        } else if (string.compareToIgnoreCase("SCIENTIFIC") == 0) {
            dumpFormat = 2;
        }
    }
}

