/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;

public class EnergyPlotter
implements Configurable {
    @S4Integer(defaultValue=20)
    public static final String PROP_MAX_ENERGY = "maxEnergy";
    private int maxEnergy;
    private String[] plots;

    public EnergyPlotter(int n) {
        this.maxEnergy = n;
        this.buildPlots(n);
    }

    public EnergyPlotter() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.maxEnergy = propertySheet.getInt(PROP_MAX_ENERGY);
        this.buildPlots(this.maxEnergy);
    }

    private void buildPlots(int n) {
        this.plots = new String[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            this.plots[i] = this.getPlotString(i);
        }
    }

    private String getPlotString(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, '.');
        if (n > 0) {
            if (n < 10) {
                cArray[cArray.length - 1] = (char)(48 + n);
            } else {
                cArray[cArray.length - 2] = 49;
                cArray[cArray.length - 1] = (char)(48 + (n - 10));
            }
        }
        return '+' + new String(cArray);
    }

    public void plot(Data data) {
        if (data != null) {
            if (data instanceof DoubleData) {
                int n = (int)((DoubleData)data).getValues()[0];
                System.out.println(this.getPlot(n));
            } else {
                System.out.println(data);
            }
        }
    }

    private String getPlot(int n) {
        if (n < 0) {
            return "-";
        }
        if (n <= this.maxEnergy) {
            return this.plots[n];
        }
        return this.getPlotString(n);
    }
}

