/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.frontend.util.Utterance;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class Microphone
extends BaseDataProcessor {
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    @S4Boolean(defaultValue=true)
    public static final String PROP_CLOSE_BETWEEN_UTTERANCES = "closeBetweenUtterances";
    @S4Integer(defaultValue=10)
    public static final String PROP_MSEC_PER_READ = "msecPerRead";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Integer(defaultValue=1)
    public static final String PROP_CHANNELS = "channels";
    @S4Boolean(defaultValue=true)
    public static final String PROP_BIG_ENDIAN = "bigEndian";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SIGNED = "signed";
    @S4Boolean(defaultValue=false)
    public static final String PROP_KEEP_LAST_AUDIO = "keepLastAudio";
    @S4String(defaultValue="average", range={"average", "selectChannel"})
    public static final String PROP_STEREO_TO_MONO = "stereoToMono";
    @S4Integer(defaultValue=0)
    public static final String PROP_SELECT_CHANNEL = "selectChannel";
    @S4String(defaultValue="default")
    public static final String PROP_SELECT_MIXER = "selectMixer";
    @S4Integer(defaultValue=6400)
    public static final String PROP_BUFFER_SIZE = "bufferSize";
    private AudioFormat finalFormat;
    private AudioInputStream audioStream;
    private TargetDataLine audioLine;
    private BlockingQueue<Data> audioList;
    private Utterance currentUtterance;
    private boolean doConversion;
    private volatile boolean recording;
    private volatile boolean utteranceEndReached = true;
    private RecordingThread recorder;
    private AudioFormat desiredFormat;
    private boolean closeBetweenUtterances;
    private boolean keepDataReference;
    private boolean signed;
    private boolean bigEndian;
    private int frameSizeInBytes;
    private int msecPerRead;
    private int selectedChannel;
    private String selectedMixerIndex;
    private String stereoToMono;
    private int sampleRate;
    private int audioBufferSize;

    public Microphone(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, boolean bl4, String string, int n5, String string2, int n6) {
        this.initLogger();
        this.sampleRate = n;
        this.bigEndian = bl;
        this.signed = bl2;
        this.desiredFormat = new AudioFormat(n, n2, n3, bl2, bl);
        this.closeBetweenUtterances = bl3;
        this.msecPerRead = n4;
        this.keepDataReference = bl4;
        this.stereoToMono = string;
        this.selectedChannel = n5;
        this.selectedMixerIndex = string2;
        this.audioBufferSize = n6;
    }

    public Microphone() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.logger = propertySheet.getLogger();
        this.sampleRate = propertySheet.getInt(PROP_SAMPLE_RATE);
        int n = propertySheet.getInt(PROP_BITS_PER_SAMPLE);
        int n2 = propertySheet.getInt(PROP_CHANNELS);
        this.bigEndian = propertySheet.getBoolean(PROP_BIG_ENDIAN);
        this.signed = propertySheet.getBoolean(PROP_SIGNED);
        this.desiredFormat = new AudioFormat(this.sampleRate, n, n2, this.signed, this.bigEndian);
        this.closeBetweenUtterances = propertySheet.getBoolean(PROP_CLOSE_BETWEEN_UTTERANCES);
        this.msecPerRead = propertySheet.getInt(PROP_MSEC_PER_READ);
        this.keepDataReference = propertySheet.getBoolean(PROP_KEEP_LAST_AUDIO);
        this.stereoToMono = propertySheet.getString(PROP_STEREO_TO_MONO);
        this.selectedChannel = propertySheet.getInt(PROP_SELECT_CHANNEL);
        this.selectedMixerIndex = propertySheet.getString(PROP_SELECT_MIXER);
        this.audioBufferSize = propertySheet.getInt(PROP_BUFFER_SIZE);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.audioList = new LinkedBlockingQueue<Data>();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.desiredFormat);
        if (!AudioSystem.isLineSupported(info)) {
            this.logger.info(this.desiredFormat + " not supported");
            AudioFormat audioFormat = DataUtil.getNativeAudioFormat(this.desiredFormat, this.getSelectedMixer());
            if (audioFormat == null) {
                this.logger.severe("couldn't find suitable target audio format");
            } else {
                this.finalFormat = audioFormat;
                this.doConversion = AudioSystem.isConversionSupported(this.desiredFormat, audioFormat);
                if (this.doConversion) {
                    this.logger.info("Converting from " + this.finalFormat.getSampleRate() + "Hz to " + this.desiredFormat.getSampleRate() + "Hz");
                } else {
                    this.logger.info("Using native format: Cannot convert from " + this.finalFormat.getSampleRate() + "Hz to " + this.desiredFormat.getSampleRate() + "Hz");
                }
            }
        } else {
            this.logger.info("Desired format: " + this.desiredFormat + " supported.");
            this.finalFormat = this.desiredFormat;
        }
    }

    private Mixer getSelectedMixer() {
        if (this.selectedMixerIndex.equals("default")) {
            return null;
        }
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        if (this.selectedMixerIndex.equals("last")) {
            return AudioSystem.getMixer(infoArray[infoArray.length - 1]);
        }
        int n = Integer.parseInt(this.selectedMixerIndex);
        return AudioSystem.getMixer(infoArray[n]);
    }

    private TargetDataLine getAudioLine() {
        if (this.audioLine != null) {
            return this.audioLine;
        }
        try {
            this.logger.info("Final format: " + this.finalFormat);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.finalFormat);
            Mixer mixer = this.getSelectedMixer();
            this.audioLine = mixer == null ? (TargetDataLine)AudioSystem.getLine(info) : (TargetDataLine)mixer.getLine(info);
            this.audioLine.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent lineEvent) {
                    Microphone.this.logger.info("line listener " + lineEvent);
                }
            });
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.logger.severe("microphone unavailable " + lineUnavailableException.getMessage());
        }
        return this.audioLine;
    }

    private boolean open() {
        TargetDataLine targetDataLine = this.getAudioLine();
        if (targetDataLine != null) {
            if (!targetDataLine.isOpen()) {
                this.logger.info("open");
                try {
                    targetDataLine.open(this.finalFormat, this.audioBufferSize);
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.logger.severe("Can't open microphone " + lineUnavailableException.getMessage());
                    return false;
                }
                this.audioStream = new AudioInputStream(targetDataLine);
                if (this.doConversion) {
                    this.audioStream = AudioSystem.getAudioInputStream(this.desiredFormat, this.audioStream);
                    assert (this.audioStream != null);
                }
                float f = (float)this.msecPerRead / 1000.0f;
                this.frameSizeInBytes = this.audioStream.getFormat().getSampleSizeInBits() / 8 * (int)(f * this.audioStream.getFormat().getSampleRate()) * this.desiredFormat.getChannels();
                this.logger.info("Frame size: " + this.frameSizeInBytes + " bytes");
            }
            return true;
        }
        this.logger.severe("Can't find microphone");
        return false;
    }

    public AudioFormat getAudioFormat() {
        return this.finalFormat;
    }

    public Utterance getUtterance() {
        return this.currentUtterance;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public synchronized boolean startRecording() {
        if (this.recording) {
            return false;
        }
        if (!this.open()) {
            return false;
        }
        this.utteranceEndReached = false;
        if (this.audioLine.isRunning()) {
            this.logger.severe("Whoops: audio line is running");
        }
        assert (this.recorder == null);
        this.recorder = new RecordingThread("Microphone");
        this.recorder.start();
        this.recording = true;
        return true;
    }

    public synchronized void stopRecording() {
        if (this.audioLine != null) {
            if (this.recorder != null) {
                this.recorder.stopRecording();
                this.recorder = null;
            }
            this.recording = false;
        }
    }

    private double[] convertStereoToMono(double[] dArray, int n) {
        assert (dArray.length % n == 0);
        double[] dArray2 = new double[dArray.length / n];
        if (this.stereoToMono.equals("average")) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < dArray.length) {
                double d = dArray[n2++];
                for (int i = 1; i < n; ++i) {
                    d += dArray[n2++];
                }
                dArray2[n3] = d / (double)n;
                ++n3;
            }
        } else if (this.stereoToMono.equals(PROP_SELECT_CHANNEL)) {
            int n4 = this.selectedChannel;
            int n5 = 0;
            while (n4 < dArray.length) {
                dArray2[n5] = dArray[n4];
                n4 += n;
                ++n5;
            }
        } else {
            throw new Error("Unsupported stereo to mono conversion: " + this.stereoToMono);
        }
        return dArray2;
    }

    public void clear() {
        this.audioList.clear();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        if (!this.utteranceEndReached) {
            try {
                data = this.audioList.take();
            }
            catch (InterruptedException interruptedException) {
                throw new DataProcessingException("cannot take Data from audioList", interruptedException);
            }
            if (data instanceof DataEndSignal) {
                this.utteranceEndReached = true;
            }
        }
        return data;
    }

    public boolean hasMoreData() {
        return !this.utteranceEndReached || !this.audioList.isEmpty();
    }

    class RecordingThread
    extends Thread {
        private boolean done;
        private volatile boolean started;
        private long totalSamplesRead;
        private final Object lock;

        public RecordingThread(String string) {
            super(string);
            this.lock = new Object();
        }

        @Override
        public void start() {
            this.started = false;
            super.start();
            this.waitForStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRecording() {
            Microphone.this.audioLine.stop();
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.done) {
                        this.lock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.totalSamplesRead = 0L;
            Microphone.this.logger.info("started recording");
            if (Microphone.this.keepDataReference) {
                Microphone.this.currentUtterance = new Utterance("Microphone", Microphone.this.audioStream.getFormat());
            }
            Microphone.this.audioList.add(new DataStartSignal(Microphone.this.sampleRate));
            Microphone.this.logger.info("DataStartSignal added");
            try {
                Microphone.this.audioLine.start();
                while (!this.done) {
                    Data data = this.readData(Microphone.this.currentUtterance);
                    if (data == null) {
                        this.done = true;
                        break;
                    }
                    Microphone.this.audioList.add(data);
                }
                Microphone.this.audioLine.flush();
                if (Microphone.this.closeBetweenUtterances) {
                    Microphone.this.audioStream.close();
                    Microphone.this.audioLine.close();
                    System.err.println("set to null");
                    Microphone.this.audioLine = null;
                }
            }
            catch (IOException iOException) {
                Microphone.this.logger.warning("IO Exception " + iOException.getMessage());
                iOException.printStackTrace();
            }
            long l = (long)((double)this.totalSamplesRead / (double)Microphone.this.audioStream.getFormat().getSampleRate() * 1000.0);
            Microphone.this.audioList.add(new DataEndSignal(l));
            Microphone.this.logger.info("DataEndSignal ended");
            Microphone.this.logger.info("stopped recording");
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        private synchronized void waitForStart() {
            try {
                while (!this.started) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                Microphone.this.logger.warning("wait was interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Data readData(Utterance utterance) throws IOException {
            byte[] byArray = new byte[Microphone.this.frameSizeInBytes];
            int n = Microphone.this.audioStream.getFormat().getChannels();
            long l = this.totalSamplesRead / (long)n;
            int n2 = Microphone.this.audioStream.read(byArray, 0, byArray.length);
            if (!this.started) {
                RecordingThread recordingThread = this;
                synchronized (recordingThread) {
                    this.started = true;
                    this.notifyAll();
                }
            }
            if (Microphone.this.logger.isLoggable(Level.FINE)) {
                Microphone.this.logger.info("Read " + n2 + " bytes from audio stream.");
            }
            if (n2 <= 0) {
                return null;
            }
            int n3 = Microphone.this.audioStream.getFormat().getSampleSizeInBits() / 8;
            this.totalSamplesRead += (long)(n2 / n3);
            if (n2 != Microphone.this.frameSizeInBytes) {
                if (n2 % n3 != 0) {
                    throw new Error("Incomplete sample read.");
                }
                byArray = Arrays.copyOf(byArray, n2);
            }
            if (Microphone.this.keepDataReference) {
                utterance.add(byArray);
            }
            double[] dArray = Microphone.this.bigEndian ? DataUtil.bytesToValues(byArray, 0, byArray.length, n3, Microphone.this.signed) : DataUtil.littleEndianBytesToValues(byArray, 0, byArray.length, n3, Microphone.this.signed);
            if (n > 1) {
                dArray = Microphone.this.convertStereoToMono(dArray, n);
            }
            return new DoubleData(dArray, (int)Microphone.this.audioStream.getFormat().getSampleRate(), l);
        }
    }
}

